/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.enhanceddeepdark.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enhanced_deep_dark", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FogHandler {
    private static float fadeFactor = 0.0f;
    private static final float FADE_SPEED = 0.02f;
    private static boolean soundPlayed = false;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean inDeepDark;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        if (level == null || player == null) {
            return;
        }
        Biome biome = (Biome)level.m_204166_(player.m_20183_()).m_203334_();
        ResourceLocation biomeId = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
        boolean bl = inDeepDark = biomeId != null && biomeId.equals((Object)new ResourceLocation("minecraft", "deep_dark"));
        if (inDeepDark) {
            fadeFactor = Math.min(fadeFactor + 0.02f, 1.0f);
            if (!soundPlayed && fadeFactor > 0.1f) {
                mc.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(SoundEvents.f_215766_, SoundSource.AMBIENT, 1.0f, 1.0f, RandomSource.m_216327_(), BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_())));
                soundPlayed = true;
            }
        } else {
            fadeFactor = Math.max(fadeFactor - 0.02f, 0.0f);
            soundPlayed = false;
        }
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || fadeFactor <= 0.0f) {
            return;
        }
        boolean hasBlindness = player.m_21023_(MobEffects.f_19610_);
        boolean hasDarkness = player.m_21023_(MobEffects.f_216964_);
        if (hasBlindness || hasDarkness) {
            return;
        }
        event.setNearPlaneDistance(0.0f);
        event.setFarPlaneDistance(100.0f * fadeFactor);
        RenderSystem.setShaderFogColor((float)(0.384f * fadeFactor), (float)(0.965f * fadeFactor), (float)(0.984f * fadeFactor));
        event.setCanceled(true);
    }
}

