/*
 * Decompiled with CFR 0.152.
 */
package com.muhdfdeen.junction;

import com.muhdfdeen.junction.command.JunctionCommand;
import com.muhdfdeen.junction.config.Config;
import com.muhdfdeen.junction.listener.PlayerJoinListener;
import com.muhdfdeen.junction.permission.LuckPermsProvider;
import com.muhdfdeen.junction.permission.PermissionProvider;
import com.muhdfdeen.junction.permission.VaultProvider;
import com.muhdfdeen.junction.util.Logger;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import net.luckperms.api.LuckPerms;
import net.milkbowl.vault2.permission.Permission;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class Junction
extends JavaPlugin {
    private static Junction plugin;
    private Config.MainConfiguration config;
    private PermissionProvider permissionProvider;
    private Logger log;

    public void onEnable() {
        plugin = this;
        this.log = new Logger(this);
        if (!this.reload()) {
            this.log.error("Disabling plugin due to critical configuration error.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            JunctionCommand junctionCommand = new JunctionCommand(this);
            ((Commands)event.registrar()).register(junctionCommand.createCommand("junction"), "Main Junction command");
        });
        this.log.info("Plugin enabled successfully");
    }

    public boolean reload() {
        try {
            this.config = Config.load(this.getDataFolder());
            this.setupPermissionProvider();
            return true;
        }
        catch (Exception e) {
            this.log.error("Failed to load configuration: " + e.getMessage());
            return false;
        }
    }

    private void setupPermissionProvider() {
        if (!this.config.permissions.enabled()) {
            this.log.info("Permission management disabled");
            return;
        }
        String providerType = this.config.permissions.provider();
        if (providerType.equalsIgnoreCase("LuckPerms")) {
            if (this.setupLuckPerms()) {
                this.log.info("LuckPerms provider initialized");
            } else {
                this.log.warn("Failed to initialize LuckPerms, is it installed?");
            }
        } else if (providerType.equalsIgnoreCase("Vault")) {
            if (this.setupVault()) {
                this.log.info("Vault provider initialized");
            } else {
                this.log.warn("Failed to initialize Vault, is it installed?");
            }
        } else {
            this.log.warn("Unknown permission provider: " + providerType);
        }
    }

    private boolean setupLuckPerms() {
        if (this.getServer().getPluginManager().getPlugin("LuckPerms") == null) {
            return false;
        }
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(LuckPerms.class);
        if (provider == null) {
            return false;
        }
        LuckPerms luckPerms = (LuckPerms)provider.getProvider();
        String groupName = this.config.permissions.group();
        if (groupName != null && !groupName.isEmpty()) {
            if (luckPerms.getGroupManager().getGroup(groupName) == null) {
                this.log.warn("Group '" + groupName + "' not found in LuckPerms");
            } else {
                this.log.debug("Found group '" + groupName + "' in LuckPerms");
            }
        }
        this.permissionProvider = new LuckPermsProvider(luckPerms);
        return true;
    }

    private boolean setupVault() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (provider == null) {
            return false;
        }
        Permission permission = (Permission)provider.getProvider();
        String groupName = this.config.permissions.group();
        if (groupName != null && !groupName.isEmpty()) {
            CharSequence[] groups = permission.getGroups();
            boolean groupExists = false;
            for (String string : groups) {
                if (!string.equalsIgnoreCase(groupName)) continue;
                groupExists = true;
                break;
            }
            if (!groupExists) {
                this.log.warn("Group '" + groupName + "' not found in " + permission.getName());
                this.log.warn("Available groups: " + String.join((CharSequence)", ", groups));
            } else {
                this.log.debug("Found group '" + groupName + "' in " + permission.getName());
            }
        }
        this.permissionProvider = new VaultProvider(permission);
        return true;
    }

    public static Junction getPlugin() {
        return plugin;
    }

    public Logger getPluginLogger() {
        return this.log;
    }

    public Config.MainConfiguration getConfiguration() {
        return this.config;
    }

    public PermissionProvider getPermissionProvider() {
        return this.permissionProvider;
    }
}

