/*
 * Decompiled with CFR 0.152.
 */
package com.muhdfdeen.junction.config;

import com.muhdfdeen.junction.libs.configlib.Comment;
import com.muhdfdeen.junction.libs.configlib.ConfigLib;
import com.muhdfdeen.junction.libs.configlib.Configuration;
import com.muhdfdeen.junction.libs.configlib.YamlConfigurationProperties;
import com.muhdfdeen.junction.libs.configlib.YamlConfigurations;
import java.io.File;
import java.nio.file.Path;

public final class Config {
    public static MainConfiguration load(File dataFolder) {
        YamlConfigurationProperties properties = ((YamlConfigurationProperties.Builder)ConfigLib.BUKKIT_DEFAULT_PROPERTIES.toBuilder()).build();
        Path configFile = new File(dataFolder, "config.yml").toPath();
        return YamlConfigurations.update(configFile, MainConfiguration.class, properties);
    }

    @Configuration
    public static final class MainConfiguration
    extends BaseConfiguration {
        @Comment(value={"This module automatically assigns Bedrock Edition players to a specific group."})
        public PermissionSettings permissions = new PermissionSettings(false, "LuckPerms", "geyser");
    }

    public record PermissionSettings(@Comment(value={"Should this module be enabled?"}) boolean enabled, @Comment(value={"Which permission provider should be used?", "Available options: LuckPerms, Vault"}) String provider, @Comment(value={"Which permission group should players be assigned to?"}) String group) {
    }

    @Configuration
    public static class BaseConfiguration {
        @Comment(value={"Should debug mode be enabled for detailed logs?"})
        public boolean debug = false;
    }
}

