/*
 * Decompiled with CFR 0.152.
 */
package com.nbp.cobblemon_smartphone.network.handler.server;

import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.nbp.cobblemon_smartphone.CobblemonSmartphone;
import com.nbp.cobblemon_smartphone.network.handler.server.EnderChestCooldowns;
import com.nbp.cobblemon_smartphone.network.packet.OpenEnderChestPacket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/nbp/cobblemon_smartphone/network/handler/server/OpenEnderChestHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/nbp/cobblemon_smartphone/network/packet/OpenEnderChestPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "handle", "(Lcom/nbp/cobblemon_smartphone/network/packet/OpenEnderChestPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerPlayer;)V", "openEnderChestForPlayer", "(Lnet/minecraft/server/level/ServerPlayer;)V", "cobblemon_smartphone-common"})
public final class OpenEnderChestHandler
implements ServerNetworkPacketHandler<OpenEnderChestPacket> {
    @NotNull
    public static final OpenEnderChestHandler INSTANCE = new OpenEnderChestHandler();

    private OpenEnderChestHandler() {
    }

    public void handle(@NotNull OpenEnderChestPacket packet, @NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        server.execute(() -> OpenEnderChestHandler.handle$lambda$0(player));
    }

    private final void openEnderChestForPlayer(ServerPlayer player) {
        PlayerEnderChestContainer enderChestInventory = player.getEnderChestInventory();
        player.openMenu(new MenuProvider(enderChestInventory){
            final /* synthetic */ PlayerEnderChestContainer $enderChestInventory;
            {
                this.$enderChestInventory = $enderChestInventory;
            }

            public MutableComponent getDisplayName() {
                return Component.translatable((String)"container.enderchest");
            }

            public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player playerEntity) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
                ChestMenu chestMenu = ChestMenu.threeRows((int)containerId, (Inventory)playerInventory, (Container)((Container)this.$enderChestInventory));
                Intrinsics.checkNotNullExpressionValue((Object)chestMenu, (String)"threeRows(...)");
                return (AbstractContainerMenu)chestMenu;
            }
        });
    }

    private static final void handle$lambda$0(ServerPlayer $player) {
        int cooldown;
        boolean isEnabled = CobblemonSmartphone.INSTANCE.getConfig().getFeatures().getEnableCloud();
        if (!isEnabled) {
            $player.displayClientMessage((Component)Component.translatable((String)"message.nbp.cloud.disabled").withColor(16580864), true);
            return;
        }
        long currentTime = System.currentTimeMillis() / (long)1000;
        Long l = EnderChestCooldowns.INSTANCE.getLastEnderChestUse().get($player.getUUID());
        long lastUse = l != null ? l : 0L;
        long timeElapsed = currentTime - lastUse;
        if (timeElapsed < (long)(cooldown = CobblemonSmartphone.INSTANCE.getConfig().getCooldowns().getCloudButton())) {
            int remainingSeconds = (int)((long)cooldown - timeElapsed);
            Object[] objectArray = new Object[]{remainingSeconds};
            $player.displayClientMessage((Component)Component.translatable((String)"message.nbp.cloud.cooldown", (Object[])objectArray).withColor(16580864), true);
            return;
        }
        EnderChestCooldowns.INSTANCE.getLastEnderChestUse().put($player.getUUID(), currentTime);
        INSTANCE.openEnderChestForPlayer($player);
    }
}

