/*
 * Decompiled with CFR 0.152.
 */
package io.felipeandrade.metalmancy.fabric.registry;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.felipeandrade.metalmancy.fabric.registry.WorldGen;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J#\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lio/felipeandrade/metalmancy/fabric/registry/WorldGen;", "", "<init>", "()V", "", "register", "Lcom/google/gson/JsonElement;", "jsonElement", "", "Ljava/util/function/Predicate;", "Lnet/fabricmc/fabric/api/biome/v1/BiomeSelectionContext;", "parseBiomeSelectors", "(Lcom/google/gson/JsonElement;)Ljava/util/List;", "", "token", "createSelector", "(Ljava/lang/String;)Ljava/util/function/Predicate;", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "metalmancy-fabric"})
@SourceDebugExtension(value={"SMAP\nWorldGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldGen.kt\nio/felipeandrade/metalmancy/fabric/registry/WorldGen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1869#2,2:100\n*S KotlinDebug\n*F\n+ 1 WorldGen.kt\nio/felipeandrade/metalmancy/fabric/registry/WorldGen\n*L\n78#1:100,2\n*E\n"})
public final class WorldGen {
    @NotNull
    public static final WorldGen INSTANCE = new WorldGen();
    @NotNull
    private static final Gson GSON = new Gson();

    private WorldGen() {
    }

    public final void register() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                class_2960 class_29602 = class_2960.method_60655((String)"metalmancy", (String)"worldgen_auto_biome_loader");
                Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"fromNamespaceAndPath(...)");
                return class_29602;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void method_14491(class_3300 resourceManager) {
                Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
                String modifierDir = "modifier/biome";
                Predicate<class_2960> modifierFilter = register.1::onResourceManagerReload$lambda$0;
                Map map = resourceManager.method_14488(modifierDir, modifierFilter);
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"listResources(...)");
                Map $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    JsonElement biomesEl;
                    List biomeSelectors;
                    List features;
                    List list;
                    InputStream root;
                    InputStream input;
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator.next();
                    boolean bl = false;
                    class_3298 resource = (class_3298)entry.getValue();
                    Closeable closeable = resource.method_14482();
                    Throwable throwable = null;
                    try {
                        input = (InputStream)closeable;
                        boolean bl2 = false;
                        input = (JsonObject)WorldGen.access$getGSON$p().fromJson((Reader)new InputStreamReader(input), JsonObject.class);
                    }
                    catch (Throwable bl2) {
                        throwable = bl2;
                        throw bl2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)input, (String)"use(...)");
                    class_2893.class_2895 step = class_2893.class_2895.field_13176;
                    JsonArray jsonArray = root.getAsJsonArray("features");
                    if (jsonArray != null) {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = (Iterable)jsonArray;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach2 = false;
                        Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            String it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl3 = false;
                            JsonElement it = (JsonElement)element$iv$iv;
                            boolean bl4 = false;
                            if (it.getAsString() == null) continue;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        list = (List)destination$iv$iv;
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    if ((features = list).isEmpty() || root.get("biomes") == null || (biomeSelectors = WorldGen.access$parseBiomeSelectors(WorldGen.INSTANCE, biomesEl)).isEmpty()) continue;
                    Predicate<BiomeSelectionContext> selector = arg_0 -> register.1.onResourceManagerReload$lambda$6$lambda$4(biomeSelectors, arg_0);
                    for (String feat : features) {
                        class_5321 pfKey;
                        class_2960 featId = class_2960.method_60654((String)feat);
                        Intrinsics.checkNotNullExpressionValue((Object)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)featId), (String)"create(...)");
                        BiomeModification modification = BiomeModifications.create((class_2960)featId);
                        modification.add(ModificationPhase.ADDITIONS, selector, arg_0 -> register.1.onResourceManagerReload$lambda$6$lambda$5(step, pfKey, arg_0));
                    }
                }
            }

            private static final boolean onResourceManagerReload$lambda$0(class_2960 it) {
                String string = it.method_12832();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                return StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)it.method_12836(), (Object)"metalmancy");
            }

            private static final boolean onResourceManagerReload$lambda$6$lambda$4(List $biomeSelectors, BiomeSelectionContext context) {
                boolean bl;
                block3: {
                    Iterable $this$any$iv = $biomeSelectors;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Predicate it = (Predicate)element$iv;
                            boolean bl2 = false;
                            if (!it.test(context)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private static final void onResourceManagerReload$lambda$6$lambda$5(class_2893.class_2895 $step, class_5321 $pfKey, BiomeModificationContext context) {
                context.getGenerationSettings().addFeature($step, $pfKey);
            }
        });
    }

    private final List<Predicate<BiomeSelectionContext>> parseBiomeSelectors(JsonElement jsonElement) {
        List selectors = new ArrayList();
        if (jsonElement.isJsonPrimitive()) {
            String token = jsonElement.getAsString();
            Intrinsics.checkNotNull((Object)token);
            selectors.add(this.createSelector(token));
        } else if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$forEach$iv = (Iterable)jsonArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement it = (JsonElement)element$iv;
                boolean bl = false;
                String token = it.getAsString();
                Intrinsics.checkNotNull((Object)token);
                selectors.add(INSTANCE.createSelector(token));
            }
        }
        return selectors;
    }

    private final Predicate<BiomeSelectionContext> createSelector(String token) {
        Predicate predicate;
        if (StringsKt.startsWith$default((String)token, (String)"#", (boolean)false, (int)2, null)) {
            String string = token.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            class_2960 tagId = class_2960.method_60654((String)string);
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tagId);
            Predicate predicate2 = BiomeSelectors.tag((class_6862)tagKey);
            Intrinsics.checkNotNull((Object)predicate2);
            predicate = predicate2;
        } else {
            class_2960 biomeId = class_2960.method_60654((String)token);
            class_5321 biomeKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeId);
            class_5321[] class_5321Array = new class_5321[]{biomeKey};
            Predicate predicate3 = BiomeSelectors.includeByKey((class_5321[])class_5321Array);
            Intrinsics.checkNotNull((Object)predicate3);
            predicate = predicate3;
        }
        return predicate;
    }

    public static final /* synthetic */ Gson access$getGSON$p() {
        return GSON;
    }

    public static final /* synthetic */ List access$parseBiomeSelectors(WorldGen $this, JsonElement jsonElement) {
        return $this.parseBiomeSelectors(jsonElement);
    }
}

