/*
 * Decompiled with CFR 0.152.
 */
package tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tools.OreGen;
import tools.OreGenEntries;
import tools.OreGenTarget;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u001a\u001b\u0010\u0004\u001a\u00020\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0013\u0010\u0007\u001a\u00020\u0001*\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0013\u0010\t\u001a\u00020\u0001*\u00020\u0006H\u0000\u00a2\u0006\u0004\b\t\u0010\b\u001a7\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000bj\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f`\r*\u00020\u00062\u0006\u0010\n\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a/\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000bj\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f`\r*\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00012\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0000\"\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a+\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00180\u0017H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a7\u0010 \u001a\u00020\u0003*\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00012\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u001eH\u0002\u00a2\u0006\u0004\b \u0010!\u00a8\u0006\""}, d2={"", "", "args", "", "main", "([Ljava/lang/String;)V", "Ltools/OreGen;", "toConfiguredName", "(Ltools/OreGen;)Ljava/lang/String;", "toPlacedName", "configFileName", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "toPlacedFeature", "(Ltools/OreGen;Ljava/lang/String;)Ljava/util/LinkedHashMap;", "toConfiguredFeatureJson", "(Ltools/OreGen;)Ljava/util/LinkedHashMap;", "base", "parts", "Ljava/io/File;", "dir", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/io/File;", "", "", "counts", "nextUnique", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "Lcom/google/gson/Gson;", "fileName", "", "json", "writeJson", "(Lcom/google/gson/Gson;Ljava/io/File;Ljava/lang/String;Ljava/util/Map;)V", "metalmancy-common"})
@SourceDebugExtension(value={"SMAP\nWorldgenJsonGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldgenJsonGen.kt\ntools/WorldgenJsonGenKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class WorldgenJsonGenKt {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String outDir = "build/generated";
        for (int i = 0; i < args.length; ++i) {
            if (!Intrinsics.areEqual((Object)args[i], (Object)"--out")) continue;
            String string = (String)ArraysKt.getOrNull((Object[])args, (int)(i + 1));
            if (string == null) {
                string = outDir;
            }
            outDir = string;
            ++i;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String[] stringArray = new String[]{"configured_feature"};
        File configuredDir = WorldgenJsonGenKt.dir(outDir, stringArray);
        String[] stringArray2 = new String[]{"placed_feature"};
        File placedDir = WorldgenJsonGenKt.dir(outDir, stringArray2);
        Map configCounts = new LinkedHashMap();
        Map placedCounts = new LinkedHashMap();
        for (OreGen e : OreGenEntries.INSTANCE.getOverworld()) {
            String configuredName = WorldgenJsonGenKt.toConfiguredName(e);
            String configFileName = WorldgenJsonGenKt.nextUnique(configuredName, configCounts);
            Intrinsics.checkNotNull((Object)gson);
            WorldgenJsonGenKt.writeJson(gson, configuredDir, configFileName + ".json", (Map<String, ? extends Object>)WorldgenJsonGenKt.toConfiguredFeatureJson(e));
            String placedName = WorldgenJsonGenKt.toPlacedName(e);
            String placedFileName = WorldgenJsonGenKt.nextUnique(placedName, placedCounts);
            WorldgenJsonGenKt.writeJson(gson, placedDir, placedFileName + ".json", (Map<String, ? extends Object>)WorldgenJsonGenKt.toPlacedFeature(e, configFileName));
        }
        System.out.println((Object)("[generateJson] OK \u2192 " + outDir));
        System.out.println((Object)"[generateJson] Dica: rode ':common:syncGeneratedWorldgen' para copiar em resources.");
    }

    @NotNull
    public static final String toConfiguredName(@NotNull OreGen $this$toConfiguredName) {
        Intrinsics.checkNotNullParameter((Object)$this$toConfiguredName, (String)"<this>");
        return $this$toConfiguredName.getSuffix() != null ? $this$toConfiguredName.getOre() + "_" + $this$toConfiguredName.getSuffix() : $this$toConfiguredName.getOre();
    }

    @NotNull
    public static final String toPlacedName(@NotNull OreGen $this$toPlacedName) {
        Intrinsics.checkNotNullParameter((Object)$this$toPlacedName, (String)"<this>");
        return $this$toPlacedName.getSuffix() != null ? "oregen_" + $this$toPlacedName.getOre() + "_" + $this$toPlacedName.getSuffix() : "oregen_" + $this$toPlacedName.getOre();
    }

    @NotNull
    public static final LinkedHashMap<String, Object> toPlacedFeature(@NotNull OreGen $this$toPlacedFeature, @NotNull String configFileName) {
        Intrinsics.checkNotNullParameter((Object)$this$toPlacedFeature, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configFileName, (String)"configFileName");
        List placement = new ArrayList();
        Collection collection = placement;
        Object object = new Pair[]{TuplesKt.to((Object)"type", (Object)"minecraft:count"), TuplesKt.to((Object)"count", (Object)$this$toPlacedFeature.getCountPerChunk())};
        collection.add(MapsKt.linkedMapOf((Pair[])object));
        collection = placement;
        object = new Pair[]{TuplesKt.to((Object)"type", (Object)"minecraft:in_square")};
        collection.add(MapsKt.linkedMapOf((Pair[])object));
        object = new Pair[3];
        object[0] = TuplesKt.to((Object)"type", (Object)$this$toPlacedFeature.getHeightType().getId());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"absolute", (Object)$this$toPlacedFeature.getYRange().getFirst())};
        object[1] = TuplesKt.to((Object)"min_inclusive", (Object)MapsKt.linkedMapOf((Pair[])pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)"absolute", (Object)$this$toPlacedFeature.getYRange().getLast())};
        object[2] = TuplesKt.to((Object)"max_inclusive", (Object)MapsKt.linkedMapOf((Pair[])pairArray));
        LinkedHashMap height = MapsKt.linkedMapOf((Pair[])object);
        object = placement;
        pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"minecraft:height_range"), TuplesKt.to((Object)"height", (Object)height)};
        object.add(MapsKt.linkedMapOf((Pair[])pairArray));
        object = placement;
        pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"minecraft:biome")};
        object.add(MapsKt.linkedMapOf((Pair[])pairArray));
        pairArray = new Pair[]{TuplesKt.to((Object)"feature", (Object)("metalmancy:" + configFileName)), TuplesKt.to((Object)"placement", (Object)placement)};
        LinkedHashMap placed = MapsKt.linkedMapOf((Pair[])pairArray);
        return placed;
    }

    @NotNull
    public static final LinkedHashMap<String, Object> toConfiguredFeatureJson(@NotNull OreGen $this$toConfiguredFeatureJson) {
        Intrinsics.checkNotNullParameter((Object)$this$toConfiguredFeatureJson, (String)"<this>");
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        ((Map)root).put("type", "minecraft:ore");
        LinkedHashMap config = new LinkedHashMap();
        ((Map)config).put("size", $this$toConfiguredFeatureJson.getVeinSize());
        ((Map)config).put("discard_chance_on_air_exposure", 0.0);
        List jsonTargets = new ArrayList();
        if ($this$toConfiguredFeatureJson.getTargets() != null) {
            for (OreGenTarget target : $this$toConfiguredFeatureJson.getTargets()) {
                Collection collection = jsonTargets;
                Pair[] pairArray = new Pair[2];
                Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"predicate_type", (Object)target.getPredicateType().getId()), TuplesKt.to((Object)"block", (Object)target.getBlock())};
                pairArray[0] = TuplesKt.to((Object)"target", (Object)MapsKt.linkedMapOf((Pair[])pairArray2));
                pairArray2 = new Pair[]{TuplesKt.to((Object)"Name", (Object)("metalmancy:" + $this$toConfiguredFeatureJson.getOre()))};
                pairArray[1] = TuplesKt.to((Object)"state", (Object)MapsKt.linkedMapOf((Pair[])pairArray2));
                collection.add(MapsKt.linkedMapOf((Pair[])pairArray));
            }
        } else {
            Object object = jsonTargets;
            Pair[] pairArray = new Pair[2];
            Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)"predicate_type", (Object)"minecraft:tag_match"), TuplesKt.to((Object)"tag", (Object)"minecraft:stone_ore_replaceables")};
            pairArray[0] = TuplesKt.to((Object)"target", (Object)MapsKt.linkedMapOf((Pair[])pairArray3));
            pairArray3 = new Pair[]{TuplesKt.to((Object)"Name", (Object)("metalmancy:" + $this$toConfiguredFeatureJson.getOre()))};
            pairArray[1] = TuplesKt.to((Object)"state", (Object)MapsKt.linkedMapOf((Pair[])pairArray3));
            object.add(MapsKt.linkedMapOf((Pair[])pairArray));
            object = $this$toConfiguredFeatureJson.getDeepslate();
            if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                object = jsonTargets;
                pairArray = new Pair[2];
                pairArray3 = new Pair[]{TuplesKt.to((Object)"predicate_type", (Object)"minecraft:tag_match"), TuplesKt.to((Object)"tag", (Object)"minecraft:deepslate_ore_replaceables")};
                pairArray[0] = TuplesKt.to((Object)"target", (Object)MapsKt.linkedMapOf((Pair[])pairArray3));
                pairArray3 = new Pair[]{TuplesKt.to((Object)"Name", (Object)("metalmancy:" + $this$toConfiguredFeatureJson.getDeepslate()))};
                pairArray[1] = TuplesKt.to((Object)"state", (Object)MapsKt.linkedMapOf((Pair[])pairArray3));
                object.add(MapsKt.linkedMapOf((Pair[])pairArray));
            }
        }
        ((Map)config).put("targets", jsonTargets);
        ((Map)root).put("config", config);
        return root;
    }

    private static final File dir(String base, String ... parts) {
        File f = new File(base);
        for (String p : parts) {
            f = new File(f, p);
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    @NotNull
    public static final String nextUnique(@NotNull String base, @NotNull Map<String, Integer> counts) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter(counts, (String)"counts");
        Integer n = counts.compute(base, (arg_0, arg_1) -> WorldgenJsonGenKt.nextUnique$lambda$1(WorldgenJsonGenKt::nextUnique$lambda$0, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)n);
        int n2 = ((Number)n).intValue();
        return n2 == 1 ? base : base + "_" + n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeJson(Gson $this$writeJson, File dir, String fileName, Map<String, ? extends Object> json) {
        File out = new File(dir, fileName);
        Closeable closeable = new FileWriter(out);
        Throwable throwable = null;
        try {
            FileWriter w = (FileWriter)closeable;
            boolean bl = false;
            $this$writeJson.toJson(json, (Appendable)w);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        System.out.println((Object)("[generateJson] wrote " + out.getPath()));
    }

    private static final Integer nextUnique$lambda$0(String string, Integer prev) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Integer n = prev;
        return (n != null ? n : 0) + 1;
    }

    private static final Integer nextUnique$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }
}

