/*
 * Decompiled with CFR 0.152.
 */
package tools.blockgen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tools.blockgen.BlockEntries;
import tools.blockgen.GeneratedBlock;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001b\u0010\u0004\u001a\u00020\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a+\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0000\"\u00020\u0001H\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a+\u0010\u000f\u001a\u00020\u0003*\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"", "", "args", "", "main", "([Ljava/lang/String;)V", "base", "parts", "Ljava/io/File;", "dir", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/io/File;", "Lcom/google/gson/Gson;", "fileName", "Lcom/google/gson/JsonObject;", "json", "writeJson", "(Lcom/google/gson/Gson;Ljava/io/File;Ljava/lang/String;Lcom/google/gson/JsonObject;)V", "metalmancy-common"})
@SourceDebugExtension(value={"SMAP\nBlockGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockGen.kt\ntools/blockgen/BlockGenKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class BlockGenKt {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String outDir = "build/generated/assets";
        for (int i = 0; i < args.length; ++i) {
            if (!Intrinsics.areEqual((Object)args[i], (Object)"--out")) continue;
            String string = (String)ArraysKt.getOrNull((Object[])args, (int)(i + 1));
            if (string == null) {
                string = outDir;
            }
            outDir = string;
            ++i;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String[] stringArray = new String[]{"metalmancy", "blockstates"};
        File blockStatesDir = BlockGenKt.dir(outDir, stringArray);
        String[] stringArray2 = new String[]{"metalmancy", "models", "block"};
        File blockModelsDir = BlockGenKt.dir(outDir, stringArray2);
        for (GeneratedBlock block : BlockEntries.INSTANCE.getBlocks()) {
            JsonObject blockStateJson = block.generateBlockState();
            Intrinsics.checkNotNull((Object)gson);
            BlockGenKt.writeJson(gson, blockStatesDir, block.getUnlocalizedName() + ".json", blockStateJson);
            JsonObject blockModelJson = block.generateBlockModel();
            BlockGenKt.writeJson(gson, blockModelsDir, block.getUnlocalizedName() + ".json", blockModelJson);
        }
        System.out.println((Object)("[BlockGen] OK \u2192 " + outDir));
    }

    private static final File dir(String base, String ... parts) {
        File f = new File(base);
        for (String p : parts) {
            f = new File(f, p);
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeJson(Gson $this$writeJson, File dir, String fileName, JsonObject json) {
        File out = new File(dir, fileName);
        Closeable closeable = new FileWriter(out);
        Throwable throwable = null;
        try {
            FileWriter w = (FileWriter)closeable;
            boolean bl = false;
            $this$writeJson.toJson((JsonElement)json, (Appendable)w);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        System.out.println((Object)("[BlockGen] wrote " + out.getPath()));
    }
}

