/*
 * Decompiled with CFR 0.152.
 */
package tools.lootgen;

import com.google.gson.GsonBuilder;
import io.felipeandrade.metalmancy.registry.material.Part;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.lootgen.GeneratedLoot;
import tools.lootgen.LootEntries;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0005\u001a\u001b\u0010\u0004\u001a\u00020\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001f\u0010\n\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a+\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0017\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"", "", "args", "", "main", "([Ljava/lang/String;)V", "Ltools/lootgen/GeneratedLoot;", "entry", "Lio/felipeandrade/metalmancy/registry/material/Part;", "orePart", "getLootTableFileName", "(Ltools/lootgen/GeneratedLoot;Lio/felipeandrade/metalmancy/registry/material/Part;)Ljava/lang/String;", "", "", "createBlockLootTable", "(Ltools/lootgen/GeneratedLoot;Lio/felipeandrade/metalmancy/registry/material/Part;)Ljava/util/Map;", "getDropName", "(Ltools/lootgen/GeneratedLoot;)Ljava/lang/String;", "metalmancy-common"})
public final class LootGenKt {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String outDir = "build/generated/loot_table";
        for (int i = 0; i < args.length; ++i) {
            if (!Intrinsics.areEqual((Object)args[i], (Object)"--out")) continue;
            String string = (String)ArraysKt.getOrNull((Object[])args, (int)(i + 1));
            if (string == null) {
                string = outDir;
            }
            outDir = string;
            ++i;
        }
        File targetFile = new File(outDir + "/blocks");
        targetFile.mkdirs();
        for (GeneratedLoot entry : LootEntries.INSTANCE.getEntries()) {
            for (Part orePart : entry.getOres()) {
                Map<String, Object> lootTable = LootGenKt.createBlockLootTable(entry, orePart);
                String json = new GsonBuilder().setPrettyPrinting().create().toJson(lootTable);
                String fileName = LootGenKt.getLootTableFileName(entry, orePart);
                File file = new File(targetFile, fileName);
                Intrinsics.checkNotNull((Object)json);
                FilesKt.writeText$default((File)file, (String)json, null, (int)2, null);
            }
        }
    }

    @NotNull
    public static final String getLootTableFileName(@NotNull GeneratedLoot entry, @NotNull Part orePart) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)((Object)orePart), (String)"orePart");
        return WhenMappings.$EnumSwitchMapping$0[orePart.ordinal()] == 1 ? entry.getOreName() + "_deepslate_ore.json" : entry.getOreName() + "_ore.json";
    }

    @NotNull
    public static final Map<String, Object> createBlockLootTable(@NotNull GeneratedLoot entry, @NotNull Part orePart) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)((Object)orePart), (String)"orePart");
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"condition", (Object)"minecraft:match_tool");
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"enchantment", (Object)"minecraft:silk_touch"), TuplesKt.to((Object)"levels", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"min", (Object)1)))};
        pairArray[1] = TuplesKt.to((Object)"predicate", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"predicates", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"minecraft:enchantments", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray2)))))));
        Map silkTouchCondition = MapsKt.mapOf((Pair[])pairArray);
        String oreName = WhenMappings.$EnumSwitchMapping$0[orePart.ordinal()] == 1 ? entry.getOreName() + "_deepslate_ore" : entry.getOreName() + "_ore";
        Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)"type", (Object)"minecraft:item"), TuplesKt.to((Object)"conditions", (Object)CollectionsKt.listOf((Object)silkTouchCondition)), TuplesKt.to((Object)"name", (Object)("metalmancy:" + oreName))};
        Map silkTouchAlternative = MapsKt.mapOf((Pair[])pairArray3);
        Object[] objectArray = new Map[2];
        Pair[] pairArray4 = new Pair[]{TuplesKt.to((Object)"function", (Object)"minecraft:apply_bonus"), TuplesKt.to((Object)"enchantment", (Object)"minecraft:fortune"), TuplesKt.to((Object)"formula", (Object)"minecraft:ore_drops")};
        objectArray[0] = MapsKt.mapOf((Pair[])pairArray4);
        objectArray[1] = MapsKt.mapOf((Pair)TuplesKt.to((Object)"function", (Object)"minecraft:explosion_decay"));
        List fortuneFunctions = CollectionsKt.listOf((Object[])objectArray);
        pairArray4 = new Pair[]{TuplesKt.to((Object)"type", (Object)"minecraft:item"), TuplesKt.to((Object)"name", (Object)LootGenKt.getDropName(entry)), TuplesKt.to((Object)"functions", (Object)fortuneFunctions)};
        Map normalDropAlternative = MapsKt.mapOf((Pair[])pairArray4);
        Pair[] pairArray5 = new Pair[2];
        pairArray5[0] = TuplesKt.to((Object)"type", (Object)"minecraft:alternatives");
        Object[] objectArray2 = new Map[]{silkTouchAlternative, normalDropAlternative};
        pairArray5[1] = TuplesKt.to((Object)"children", (Object)CollectionsKt.listOf((Object[])objectArray2));
        Map alternativesEntry = MapsKt.mapOf((Pair[])pairArray5);
        objectArray2 = new Pair[]{TuplesKt.to((Object)"rolls", (Object)1.0), TuplesKt.to((Object)"bonus_rolls", (Object)0.0), TuplesKt.to((Object)"entries", (Object)CollectionsKt.listOf((Object)alternativesEntry))};
        Map pool = MapsKt.mapOf((Pair[])objectArray2);
        objectArray2 = new Pair[]{TuplesKt.to((Object)"type", (Object)"minecraft:block"), TuplesKt.to((Object)"pools", (Object)CollectionsKt.listOf((Object)pool)), TuplesKt.to((Object)"random_sequence", (Object)("metalmancy:blocks/" + oreName))};
        return MapsKt.mapOf((Pair[])objectArray2);
    }

    @NotNull
    public static final String getDropName(@NotNull GeneratedLoot entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return switch (WhenMappings.$EnumSwitchMapping$0[entry.getDrop().ordinal()]) {
            case 2 -> "metalmancy:raw_" + entry.getOreName();
            case 3 -> "metalmancy:" + entry.getOreName() + "_dust";
            case 4 -> "metalmancy:" + entry.getOreName();
            default -> "metalmancy:" + entry.getOreName() + "_ore";
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Part.values().length];
            try {
                nArray[Part.ORE_DEEPSLATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.RAW_ITEM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.DUST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Part.GEM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

