/*
 * Decompiled with CFR 0.152.
 */
package whirlpool.mo_waystones.datagen;

import net.blay09.mods.waystones.block.WaystoneBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import whirlpool.mo_waystones.registry.ModBlocks;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "mo_waystones", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(ModBlocks.DIVINE_BRICKS);
        this.blockWithItem(ModBlocks.RUNIC_DIVINE_BRICKS);
        this.blockWithItem(ModBlocks.STABLE_DIVINE_STONE);
        this.blockWithItem(ModBlocks.UNSTABLE_DIVINE_STONE);
        this.registerWaystone((Block)ModBlocks.ICE_WAYSTONE.get(), ResourceLocation.withDefaultNamespace((String)"block/ice"));
        this.registerWaystone((Block)ModBlocks.CALCITE_WAYSTONE.get(), ResourceLocation.withDefaultNamespace((String)"block/calcite"));
        this.registerWaystone((Block)ModBlocks.POLISHED_CALCITE_WAYSTONE.get(), ResourceLocation.withDefaultNamespace((String)"block/calcite"));
        this.registerWaystone((Block)ModBlocks.MUD_BRICKS_WAYSTONE.get(), ResourceLocation.withDefaultNamespace((String)"block/mud_bricks"));
        this.registerWaystone((Block)ModBlocks.NETHER_BRICKS_WAYSTONE.get(), ResourceLocation.withDefaultNamespace((String)"block/nether_bricks"));
        this.registerWaystone((Block)ModBlocks.SEA_STONE_WAYSTONE.get(), ResourceLocation.withDefaultNamespace((String)"block/prismarine"));
        this.registerWaystone((Block)ModBlocks.TUFF_BRICKS_WAYSTONE.get(), ResourceLocation.withDefaultNamespace((String)"block/tuff_bricks"));
        this.registerWaystone((Block)ModBlocks.TUFF_WAYSTONE.get(), ResourceLocation.withDefaultNamespace((String)"block/tuff"));
        this.registerWaystone((Block)ModBlocks.SCULK_WAYSTONE.get(), ResourceLocation.withDefaultNamespace((String)"block/sculk"));
        this.registerWaystone((Block)ModBlocks.DIVINE_BRICKS_WAYSTONE.get(), ResourceLocation.fromNamespaceAndPath((String)"mo_waystones", (String)"block/divine_bricks"));
    }

    private void registerWaystone(Block block, ResourceLocation particleTexture) {
        String baseName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ResourceLocation mainTexture = ResourceLocation.fromNamespaceAndPath((String)"mo_waystones", (String)("block/" + baseName));
        ModelFile.ExistingModelFile waystoneTopParent = this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"mo_waystones", (String)"block/waystone_top"));
        ModelFile.ExistingModelFile waystoneBottomParent = this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"mo_waystones", (String)"block/waystone_bottom"));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_top")).parent((ModelFile)waystoneTopParent)).texture("particle", particleTexture)).texture("texture", mainTexture);
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_bottom")).parent((ModelFile)waystoneBottomParent)).texture("particle", particleTexture)).texture("texture", mainTexture);
        ModelFile.ExistingModelFile bottomModel = this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"mo_waystones", (String)("block/" + baseName + "_bottom")));
        ModelFile.ExistingModelFile topModel = this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"mo_waystones", (String)("block/" + baseName + "_top")));
        BooleanProperty WATERLOGGED_PROPERTY = BlockStateProperties.WATERLOGGED;
        EnumProperty ORIGIN_PROPERTY = (EnumProperty)block.getStateDefinition().getProperty("origin");
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$registerWaystone$0((ModelFile)bottomModel, (ModelFile)topModel, arg_0), new Property[]{ORIGIN_PROPERTY, WATERLOGGED_PROPERTY});
        ModelFile.ExistingModelFile waystoneItemParent = this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"mo_waystones", (String)"item/waystone"));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(baseName)).parent((ModelFile)waystoneItemParent)).texture("texture", mainTexture);
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerWaystone$0(ModelFile bottomModel, ModelFile topModel, BlockState state) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)WaystoneBlock.HALF);
        Direction facing = (Direction)state.getValue((Property)WaystoneBlock.FACING);
        int yRotation = 0;
        if (facing == Direction.EAST) {
            yRotation = 90;
        } else if (facing == Direction.SOUTH) {
            yRotation = 180;
        } else if (facing == Direction.WEST) {
            yRotation = 270;
        }
        return ConfiguredModel.builder().modelFile(half == DoubleBlockHalf.LOWER ? bottomModel : topModel).rotationY(yRotation).build();
    }
}

