/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.glomphosche.impl.client.node;

import io.github.startsmercury.glomphosche.impl.client.node.BasicNode;
import io.github.startsmercury.glomphosche.impl.client.node.Node;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class CompositeNode
extends BasicNode {
    private final ReferenceLinkedOpenHashSet<Node> registry = new ReferenceLinkedOpenHashSet();

    @Override
    public Optional<Node> visit(int codepoint) {
        for (Node node : this.registry) {
            Optional<Node> branch = node.visit(codepoint);
            if (!branch.isPresent()) continue;
            return branch;
        }
        return Optional.empty();
    }

    public Stream<Node> stream() {
        return this.registry.stream();
    }

    public Stream<Node> stream(int codepoint) {
        return this.registry.stream().flatMap(node -> node.visit(codepoint).stream());
    }

    public boolean add(Node node) {
        return this.registry.add((Object)node);
    }

    public boolean contains(Node node) {
        return this.registry.contains((Object)node);
    }

    public boolean remove(Node node) {
        return this.registry.remove((Object)node);
    }
}

