/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.glomphosche.impl.client.node;

import io.github.startsmercury.glomphosche.impl.client.node.BasicNode;
import io.github.startsmercury.glomphosche.impl.client.node.Node;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class DiscreteNode
extends BasicNode {
    private final Int2ObjectOpenHashMap<Node> branches = new Int2ObjectOpenHashMap();

    @Override
    public Optional<Node> visit(int codepoint) {
        return Optional.ofNullable((Node)this.branches.get(codepoint));
    }

    public Pair<DiscreteNode, Optional<Node>> computeDiscreteIfAbsent(int codepoint) {
        Node value = (Node)this.branches.get(codepoint);
        if (value instanceof DiscreteNode) {
            DiscreteNode branch = (DiscreteNode)value;
            return Pair.of((Object)branch, Optional.empty());
        }
        DiscreteNode branch = new DiscreteNode();
        this.branches.put(codepoint, (Object)branch);
        return Pair.of((Object)branch, Optional.ofNullable(value));
    }

    public <T extends Node> Pair<T, Optional<Node>> computeIfAbsent(int codepoint, Class<T> type, Int2ObjectFunction<T> provider) {
        Node value = (Node)this.branches.get(codepoint);
        if (type.isInstance(value)) {
            Node branch = value;
            return Pair.of((Object)branch, Optional.empty());
        }
        Node branch = (Node)provider.apply(codepoint);
        this.branches.put(codepoint, (Object)branch);
        return Pair.of((Object)branch, Optional.ofNullable(value));
    }

    public Node put(int codepoint, Node node) {
        return (Node)this.branches.put(codepoint, (Object)node);
    }
}

