package io.github.startsmercury.glomphosche.impl.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import net.minecraft.class_11719;

public class GlomphoscheNode {
    private final Int2ObjectOpenHashMap<GlomphoscheNode> branches = new Int2ObjectOpenHashMap<>();

    private Optional<class_11719.class_11721> font = Optional.empty();

    public Optional<GlomphoscheNode> get(final int codepoint) {
        return Optional.ofNullable(this.branches.get(codepoint));
    }

    public GlomphoscheNode getOrCreate(final int codepoint) {
        return this.branches.computeIfAbsent(codepoint, k -> new GlomphoscheNode());
    }

    public Optional<class_11719.class_11721> setFont(final Optional<class_11719.class_11721> font) {
        final var previous = this.font;
        this.font = font;
        return previous;
    }

    public Optional<class_11719.class_11721> register(final class_11719.class_11721 font) {
        return this.setFont(Optional.of(font));
    }

    public Optional<class_11719.class_11721> unregister() {
        return this.setFont(Optional.empty());
    }

    public Optional<class_11719.class_11721> getFont() {
        return this.font;
    }
}
