/*
 * Decompiled with CFR 0.152.
 */
package io.github.startsmercury.glomphosche.impl.client;

import io.github.startsmercury.glomphosche.impl.client.GlomphoscheImpl;
import io.github.startsmercury.glomphosche.impl.client.GlomphoscheNode;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11719;
import net.minecraft.class_2583;
import net.minecraft.class_5224;

@Environment(value=EnvType.CLIENT)
public final class GlomphoschingFormattedCharSink
implements AutoCloseable,
class_5224 {
    private final class_5224 sink;
    private final GlomphoscheNode root;
    private ObjectList<Capture> captures = new ObjectArrayList();
    private Optional<class_11719.class_11721> candidate = Optional.empty();
    private boolean success = true;
    private GlomphoscheNode tail;
    private int index;
    private class_11719.class_11721 cachedFont = GlomphoscheImpl.EMPTY_FONT;
    private class_2583 cachedFirstStyle;
    private class_2583 mappedFirstStyle = this.cachedFirstStyle = class_2583.field_24360.method_27704((class_11719)this.cachedFont);
    private class_2583 cachedPartStyle = class_2583.field_24360;
    private class_2583 mappedPartStyle = this.cachedPartStyle.method_27704((class_11719)GlomphoscheImpl.EMPTY_FONT);

    public GlomphoschingFormattedCharSink(class_5224 sink, GlomphoscheNode root) {
        this.sink = sink;
        this.root = root;
        this.tail = root;
    }

    public boolean accept(int position, class_2583 style, int codepoint) {
        ObjectArrayFIFOQueue deque = new ObjectArrayFIFOQueue();
        deque.enqueue((Object)new Capture(position, style, codepoint));
        boolean success = true;
        while (!deque.isEmpty()) {
            CatchOrPass result = this.catchOrPass((Capture)deque.dequeue(), success);
            success = result.success;
            for (Capture capture : result.remaining.reversed()) {
                deque.enqueueFirst((Object)capture);
            }
        }
        this.success = success;
        return this.success;
    }

    private CatchOrPass catchOrPass(Capture capture, boolean success) {
        ObjectList<Capture> captures = this.captures;
        int index = captures.size();
        captures.add((Object)capture);
        Optional<GlomphoscheNode> node = this.tail.get(capture.codepoint);
        if (node.isEmpty()) {
            return this.pass(captures, success);
        }
        GlomphoscheNode tail = node.get();
        if (tail.getFont().isPresent()) {
            this.candidate = tail.getFont();
            this.index = index;
        }
        this.tail = tail;
        return new CatchOrPass((ObjectList<Capture>)ObjectList.of(), success);
    }

    @Override
    public void close() {
        ObjectArrayFIFOQueue deque = new ObjectArrayFIFOQueue();
        boolean success = this.success;
        block0: while (true) {
            CatchOrPass result;
            if (!deque.isEmpty()) {
                result = this.catchOrPass((Capture)deque.dequeue(), success);
                success = result.success;
                Iterator iterator = result.remaining.reversed().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    Capture capture = (Capture)iterator.next();
                    deque.enqueueFirst((Object)capture);
                }
            }
            result = this.pass(this.captures, success);
            for (Capture capture : result.remaining) {
                deque.enqueue((Object)capture);
            }
            success = result.success;
            if (deque.isEmpty()) break;
        }
        this.success = true;
    }

    private CatchOrPass pass(ObjectList<Capture> captures, boolean success) {
        this.tail = this.root;
        this.captures = new ObjectArrayList();
        TryBuild result = this.tryBuild(captures, success);
        this.index = 0;
        return new CatchOrPass((ObjectList<Capture>)captures.subList(result.lastIndex + 1, captures.size()), result.success);
    }

    private TryBuild tryBuild(ObjectList<Capture> captures, boolean success) {
        int lastIndex;
        if (captures.isEmpty()) {
            lastIndex = -1;
        } else {
            Optional<class_11719.class_11721> candidate = this.candidate;
            this.candidate = Optional.empty();
            if (candidate.isEmpty()) {
                Capture first = (Capture)captures.getFirst();
                success = success && this.forward(first.position, first.style, first.codepoint);
                lastIndex = 0;
            } else {
                success = this.forwardFirstGlomphosched((Capture)captures.getFirst(), candidate.get(), success);
                lastIndex = this.index;
                success = this.forwardPartGlomphosched(captures, lastIndex, success);
            }
        }
        return new TryBuild(lastIndex, success);
    }

    private boolean forwardFirstGlomphosched(Capture first, class_11719.class_11721 font, boolean success) {
        class_2583 mappedStyle;
        if (font == this.cachedFont && first.style == this.cachedFirstStyle) {
            mappedStyle = this.mappedFirstStyle;
        } else {
            this.cachedFont = font;
            this.cachedFirstStyle = first.style;
            mappedStyle = this.mappedFirstStyle = first.style.method_27704((class_11719)font);
        }
        return success && this.forward(first.position, mappedStyle, first.codepoint);
    }

    private boolean forwardPartGlomphosched(ObjectList<Capture> captures, int lastIndex, boolean success) {
        class_2583 cachedStyle = this.cachedPartStyle;
        class_2583 mappedStyle = this.mappedPartStyle;
        for (int i = 1; i <= lastIndex; ++i) {
            Capture capture = (Capture)captures.get(i);
            if (capture.style != cachedStyle) {
                cachedStyle = capture.style;
                mappedStyle = capture.style.method_27704((class_11719)GlomphoscheImpl.EMPTY_FONT);
            }
            success = success && this.forward(capture.position, mappedStyle, capture.codepoint);
        }
        this.cachedPartStyle = cachedStyle;
        this.mappedPartStyle = mappedStyle;
        return success;
    }

    private boolean forward(int position, class_2583 style, int codepoint) {
        return this.sink.accept(position, style, codepoint);
    }

    @Environment(value=EnvType.CLIENT)
    private record Capture(int position, class_2583 style, int codepoint) {
    }

    @Environment(value=EnvType.CLIENT)
    private record CatchOrPass(ObjectList<Capture> remaining, boolean success) {
    }

    @Environment(value=EnvType.CLIENT)
    private record TryBuild(int lastIndex, boolean success) {
    }
}

