/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.api.event;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.eventbus.api.Event;
import top.r3944realms.lib39.core.sync.ISyncData;
import top.r3944realms.lib39.core.sync.ISyncManager;
import top.r3944realms.lib39.core.sync.SyncData2Manager;

public class SyncManagerRegisterEvent
extends Event {
    protected final SyncData2Manager syncs2Manager;

    public SyncManagerRegisterEvent(SyncData2Manager syncsManager) {
        this.syncs2Manager = syncsManager;
    }

    public SyncData2Manager getSyncsManager() {
        return this.syncs2Manager;
    }

    public <K, T extends ISyncData<?>> void registerSyncManager(ResourceLocation id, ISyncManager<K, T> syncManager, Capability<T> capability) {
        this.syncs2Manager.registerManager(id, syncManager, entity -> entity.getCapability(capability).resolve());
    }

    public <K, T extends ISyncData<?>> void registerSyncManager(ResourceLocation id, ISyncManager<K, T> syncManager, Function<Entity, Optional<T>> dataProvider) {
        this.syncs2Manager.registerManager(id, syncManager, dataProvider);
    }

    public void unregisterSyncManager(ResourceLocation id) {
        this.syncs2Manager.removeManager(id);
    }

    public final void addAllowEntityClass(ResourceLocation id, Class<?> ... entityClasses) {
        this.syncs2Manager.allowEntityClass(id, entityClasses);
    }

    public final void removeAllowEntityClass(ResourceLocation id, Class<?> ... entityClasses) {
        this.syncs2Manager.disallowEntityClass(id, entityClasses);
    }

    public <T extends ISyncData<?>> void bindCapability(ResourceLocation id, Capability<T> capability) {
        this.syncs2Manager.bindDataGetter(id, entity -> entity.getCapability(capability).resolve());
    }

    public void unbindDataProvider(ResourceLocation id) {
        this.syncs2Manager.unbindDataProvider(id);
    }

    public <K, T extends ISyncData<?>> void registerComplete(ResourceLocation id, ISyncManager<K, T> syncManager, Capability<T> capability, Class<?> ... allowedEntityClasses) {
        this.registerSyncManager(id, syncManager, capability);
        if (allowedEntityClasses.length > 0) {
            this.addAllowEntityClass(id, allowedEntityClasses);
        }
    }

    public <K, T extends ISyncData<?>> void registerComplete(ResourceLocation id, ISyncManager<K, T> syncManager, Function<Entity, Optional<T>> dataProvider, Class<?> ... allowedEntityClasses) {
        this.registerSyncManager(id, syncManager, dataProvider);
        if (allowedEntityClasses.length > 0) {
            this.addAllowEntityClass(id, allowedEntityClasses);
        }
    }
}

