/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.compat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.lib39.Lib39;
import top.r3944realms.lib39.core.compat.ICompat;

public class CompatManager {
    private final Map<ResourceLocation, ICompat> compats = new HashMap<ResourceLocation, ICompat>();
    private final IEventBus modEventBus;
    private final IEventBus gameEventBus;
    private final List<ListenerConfig> listenerConfigs = new ArrayList<ListenerConfig>();

    public CompatManager(IEventBus modEventBus, IEventBus gameEventBus) {
        this.modEventBus = modEventBus;
        this.gameEventBus = gameEventBus;
    }

    public void registerCompat(ResourceLocation id, ICompat compat) {
        if (this.compats.containsKey(id)) {
            Lib39.LOGGER.warn("Compat with id {} is already registered!", (Object)id);
            return;
        }
        this.compats.put(id, compat);
        Lib39.LOGGER.debug("Registered compat: {}", (Object)id);
    }

    public void registerCompat(String namespace, String path, ICompat compat) {
        this.registerCompat(new ResourceLocation(namespace, path), compat);
    }

    public void addListenerForAll(@Nullable Dist dists, Mod.EventBusSubscriber.Bus bus) {
        this.listenerConfigs.add(new ListenerConfig(null, dists, bus));
    }

    public void addListenerForCompat(ResourceLocation compatId, @Nullable Dist dists, Mod.EventBusSubscriber.Bus bus) {
        this.listenerConfigs.add(new ListenerConfig(compatId, dists, bus));
    }

    public void addListenerForLoaded(@Nullable Dist dists, Mod.EventBusSubscriber.Bus bus, Consumer<IEventBus> consumer) {
        this.listenerConfigs.add(new ListenerConfig(null, dists, bus){

            @Override
            boolean shouldApply(@NotNull ICompat compat) {
                return super.shouldApply(compat);
            }
        });
    }

    public void initializeAll() {
        Lib39.LOGGER.info("Initializing {} compatibility modules", (Object)this.compats.size());
        for (Map.Entry<ResourceLocation, ICompat> entry : this.compats.entrySet()) {
            try {
                entry.getValue().initialize();
                Lib39.LOGGER.info("Initialized compat: {}", (Object)entry.getKey());
            }
            catch (Exception e) {
                Lib39.LOGGER.error("Failed to initialize compat: {}", (Object)entry.getKey(), (Object)e);
            }
        }
        this.applyAllEventListeners();
    }

    private void applyAllEventListeners() {
        Lib39.LOGGER.info("Applying {} event listener configurations", (Object)this.listenerConfigs.size());
        for (ListenerConfig config : this.listenerConfigs) {
            if (config.compatId == null) {
                this.applyListenerToAllCompats(config);
                continue;
            }
            this.applyListenerToCompat(config.compatId, config);
        }
    }

    private void applyListenerToAllCompats(ListenerConfig config) {
        for (ICompat compat : this.compats.values()) {
            if (!config.shouldApply(compat)) continue;
            this.applyListenerToCompat(compat, config);
        }
    }

    private void applyListenerToCompat(ResourceLocation compatId, ListenerConfig config) {
        ICompat compat = this.compats.get(compatId);
        if (compat != null && config.shouldApply(compat)) {
            this.applyListenerToCompat(compat, config);
        }
    }

    private void applyListenerToCompat(ICompat compat, ListenerConfig config) {
        try {
            if (config.dists != null) {
                switch (config.dists) {
                    case CLIENT: {
                        if (config.bus == Mod.EventBusSubscriber.Bus.FORGE) {
                            compat.addClientGameListener(this.gameEventBus);
                            break;
                        }
                        compat.addClientModListener(this.modEventBus);
                        break;
                    }
                    case DEDICATED_SERVER: {
                        if (config.bus == Mod.EventBusSubscriber.Bus.FORGE) {
                            compat.addServerGameListener(this.gameEventBus);
                            break;
                        }
                        compat.addServerModListener(this.modEventBus);
                    }
                }
            } else if (config.bus == Mod.EventBusSubscriber.Bus.FORGE) {
                compat.addCommonGameListener(this.gameEventBus);
            } else {
                compat.addCommonModListener(this.modEventBus);
            }
            Lib39.LOGGER.debug("Applied {} listener to compat: {}", (Object)this.getListenerTypeName(config), (Object)compat.id());
        }
        catch (Exception e) {
            Lib39.LOGGER.error("Failed to apply listener to compat: {}", (Object)compat.id(), (Object)e);
        }
    }

    @NotNull
    private String getListenerTypeName(@NotNull ListenerConfig config) {
        if (config.dists != null) {
            return config.dists.name().toLowerCase() + " " + (config.bus == Mod.EventBusSubscriber.Bus.FORGE ? "game" : "mod");
        }
        return "common " + (config.bus == Mod.EventBusSubscriber.Bus.FORGE ? "game" : "mod");
    }

    public void addListenerForCompat(ResourceLocation compatId, Mod.EventBusSubscriber.Bus bus) {
        this.addListenerForCompat(compatId, null, bus);
    }

    public void onLoadComplete() {
        Lib39.LOGGER.info("Calling onLoadComplete for {} compatibility modules", (Object)this.compats.size());
        for (Map.Entry<ResourceLocation, ICompat> entry : this.compats.entrySet()) {
            try {
                entry.getValue().onLoadComplete();
            }
            catch (Exception e) {
                Lib39.LOGGER.error("Error in onLoadComplete for compat: {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    public Optional<ICompat> getCompat(ResourceLocation id) {
        return Optional.ofNullable(this.compats.get(id));
    }

    public boolean hasCompat(ResourceLocation id) {
        return this.compats.containsKey(id);
    }

    public void unregisterCompat(ResourceLocation id) {
        ICompat removed = this.compats.remove(id);
        if (removed != null) {
            Lib39.LOGGER.debug("Unregistered compat: {}", (Object)id);
        }
    }

    public List<ICompat> getLoadedCompats() {
        return this.compats.values().stream().filter(ICompat::isModLoaded).collect(Collectors.toList());
    }

    private static class ListenerConfig {
        final ResourceLocation compatId;
        final Dist dists;
        final Mod.EventBusSubscriber.Bus bus;

        ListenerConfig(ResourceLocation compatId, Dist dists, Mod.EventBusSubscriber.Bus bus) {
            this.compatId = compatId;
            this.dists = dists;
            this.bus = bus;
        }

        boolean shouldApply(@NotNull ICompat compat) {
            return compat.isModLoaded();
        }
    }
}

