/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.compat;

import java.util.concurrent.Callable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;

public interface ICompat {
    public ResourceLocation id();

    public void initialize();

    default public void onLoadComplete() {
    }

    default public boolean isModLoaded() {
        return false;
    }

    default public <T> T callIfPresent(Callable<T> callable) throws Exception {
        if (this.isModLoaded()) {
            return callable.call();
        }
        return null;
    }

    default public <T> T callIfPresent(Callable<T> callable, Callable<T> elseCall) throws Exception {
        if (this.isModLoaded()) {
            return callable.call();
        }
        return elseCall.call();
    }

    default public boolean runIfPresent(Runnable runnable) throws Exception {
        if (!this.isModLoaded()) {
            return false;
        }
        runnable.run();
        return true;
    }

    default public void addCommonGameListener(IEventBus gameBus) {
    }

    default public void addCommonModListener(IEventBus modBus) {
    }

    default public void addClientGameListener(IEventBus gameBus) {
    }

    default public void addClientModListener(IEventBus modBus) {
    }

    default public void addServerGameListener(IEventBus gameBus) {
    }

    default public void addServerModListener(IEventBus modBus) {
    }
}

