/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import top.r3944realms.lib39.Lib39;
import top.r3944realms.lib39.api.event.RegisterCompatEvent;
import top.r3944realms.lib39.api.event.SyncManagerRegisterEvent;
import top.r3944realms.lib39.core.compat.CompatManager;
import top.r3944realms.lib39.core.sync.ISyncData;
import top.r3944realms.lib39.core.sync.SyncData2Manager;

public class CommonEventHandler {

    @Mod.EventBusSubscriber(modid="lib39", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Mod
    extends CommonEventHandler {
        private static final Map<RegistryObject<Block>, ResourceKey<CreativeModeTab>[]> itemAddMap = new ConcurrentHashMap<RegistryObject<Block>, ResourceKey<CreativeModeTab>[]>();
        private static final Map<ResourceKey<CreativeModeTab>, List<RegistryObject<Block>>> tabToItemsMap = new ConcurrentHashMap<ResourceKey<CreativeModeTab>, List<RegistryObject<Block>>>();
        static volatile CompatManager compatManager;

        public static CompatManager getCompatManager() {
            return compatManager;
        }

        @SubscribeEvent
        public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
                IEventBus gameBus = MinecraftForge.EVENT_BUS;
                compatManager = new CompatManager(modBus, gameBus);
                MinecraftForge.EVENT_BUS.post((Event)new RegisterCompatEvent(compatManager));
            });
        }

        @SafeVarargs
        public static void addItemToTabs(RegistryObject<Block> item, ResourceKey<CreativeModeTab> ... tabs) {
            itemAddMap.put(item, tabs);
            for (ResourceKey<CreativeModeTab> tab : tabs) {
                tabToItemsMap.computeIfAbsent(tab, k -> new ArrayList()).add(item);
            }
        }

        @SubscribeEvent
        public static void onBuildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
            List<RegistryObject<Block>> itemsForTab = tabToItemsMap.get(event.getTabKey());
            if (itemsForTab != null) {
                itemsForTab.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            }
        }

        public static Map<RegistryObject<Block>, ResourceKey<CreativeModeTab>[]> getItemAddMap() {
            return itemAddMap;
        }
    }

    @Mod.EventBusSubscriber(modid="lib39", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Game
    extends CommonEventHandler {
        private static ServerLevel sl;
        static volatile SyncData2Manager syncData2Manager;
        private static boolean isSync2MInitialized;

        public static ServerLevel getServerLevel() {
            return sl;
        }

        public static SyncData2Manager getSyncData2Manager() {
            return syncData2Manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public static void onWorldLoad(LevelEvent.Load event) {
            Object object;
            if (event.getLevel().isClientSide() || !((object = event.getLevel()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)object;
            if (!serverLevel.dimension().equals((Object)Level.OVERWORLD)) {
                return;
            }
            object = Game.class;
            synchronized (Game.class) {
                if (!isSync2MInitialized) {
                    syncData2Manager = new SyncData2Manager();
                    MinecraftForge.EVENT_BUS.post((Event)new SyncManagerRegisterEvent(syncData2Manager));
                    isSync2MInitialized = true;
                    sl = serverLevel;
                    Lib39.LOGGER.info("SyncData2Manager initialized on world load");
                }
                // ** MonitorExit[var2_1 /* !! */ ] (shouldn't be in output)
                return;
            }
        }

        @SubscribeEvent
        public static void onWorldUnload(LevelEvent.Unload event) {
            LevelAccessor levelAccessor;
            if (event.getLevel().isClientSide() || !((levelAccessor = event.getLevel()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (!serverLevel.dimension().equals((Object)Level.OVERWORLD)) {
                return;
            }
            sl = null;
            isSync2MInitialized = false;
        }

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                if (syncData2Manager == null) {
                    return;
                }
                if (event.getServer().getTickCount() % 10 == 0) {
                    syncData2Manager.forEach((resourceLocation, iSyncManager) -> iSyncManager.foreach(ISyncData::markDirty));
                }
                syncData2Manager.forEach((resourceLocation, iSyncManager) -> iSyncManager.foreach(ISyncData::checkIfDirtyThenUpdate));
            }
        }

        @SubscribeEvent
        public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity.level().isClientSide) {
                return;
            }
            for (ResourceLocation id : syncData2Manager.getRegisteredKeys()) {
                if (!syncData2Manager.isEntityClassAllowed(id, entity.getClass())) continue;
                syncData2Manager.trackEntityForManager(entity, id);
            }
        }

        @SubscribeEvent
        public static void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity.level().isClientSide) {
                return;
            }
            for (ResourceLocation id : syncData2Manager.getRegisteredKeys()) {
                if (!syncData2Manager.isEntityClassAllowed(id, entity.getClass())) continue;
                syncData2Manager.untrackEntityForManager(entity, id);
            }
        }

        static {
            isSync2MInitialized = false;
        }
    }
}

