/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.network.toClient;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.lib39.Lib39;
import top.r3944realms.lib39.core.event.CommonEventHandler;
import top.r3944realms.lib39.core.sync.NBTEntitySyncData;
import top.r3944realms.lib39.core.sync.SyncData2Manager;

public record SyncNBTCapDataEntityS2CPack(int entityId, ResourceLocation id, CompoundTag data) {
    public SyncNBTCapDataEntityS2CPack(int entityId, ResourceLocation id, @NotNull NBTEntitySyncData data) {
        this(entityId, data.id(), (CompoundTag)data.serializeNBT());
    }

    public static void encode(@NotNull SyncNBTCapDataEntityS2CPack msg, @NotNull FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId);
        buffer.writeResourceLocation(msg.id);
        buffer.writeNbt(msg.data);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static SyncNBTCapDataEntityS2CPack decode(@NotNull FriendlyByteBuf buffer) {
        return new SyncNBTCapDataEntityS2CPack(buffer.readInt(), buffer.readResourceLocation(), buffer.readNbt());
    }

    public static void handle(SyncNBTCapDataEntityS2CPack msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && (entity = level.getEntity(msg.entityId)) != null) {
                Optional<SyncData2Manager.DataProvider<Entity, SyncData2Manager.DataProvider>> capability = CommonEventHandler.Game.getSyncData2Manager().getDataProvider(msg.id);
                capability.flatMap(dataProvider -> dataProvider.getData(entity)).ifPresent(cap -> {
                    if (cap instanceof NBTEntitySyncData) {
                        NBTEntitySyncData nbtCap = (NBTEntitySyncData)cap;
                        CompoundTag current = (CompoundTag)nbtCap.serializeNBT();
                        if (!current.equals((Object)msg.data)) {
                            nbtCap.deserializeNBT((Tag)msg.data);
                        }
                    } else {
                        Lib39.LOGGER.debug("Unhandled sync data: {}", (Object)msg.data);
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

