/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import top.r3944realms.lib39.datagen.value.ILocaleEntry;
import top.r3944realms.lib39.datagen.value.McLocale;

public class LocaleRegistry {
    private static final Map<String, ILocaleEntry> REGISTRY = new LinkedHashMap<String, ILocaleEntry>();

    public static ILocaleEntry register(ILocaleEntry entry) {
        return REGISTRY.putIfAbsent(entry.mcCode().toLowerCase(), entry);
    }

    public static ILocaleEntry fromMcCode(@NotNull String code) {
        return REGISTRY.get(code.toLowerCase());
    }

    @NotNull
    public static @UnmodifiableView Collection<ILocaleEntry> allValues() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    public static ILocaleEntry registerDynamic(@NotNull String mcCode, Locale locale) {
        return REGISTRY.computeIfAbsent(mcCode.toLowerCase(), k -> new ExtendedLocale(mcCode.toLowerCase(), locale));
    }

    static {
        for (McLocale loc : McLocale.values()) {
            LocaleRegistry.register(loc);
        }
    }

    private record ExtendedLocale(String mcCode, Locale javaLocale) implements ILocaleEntry
    {
        @Override
        @Contract(pure=true)
        @NotNull
        public String toString() {
            return "ExtendedLocale[" + this.mcCode + "]";
        }
    }
}

