/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.sync;

import java.util.Map;
import java.util.Set;
import top.r3944realms.lib39.core.sync.ISyncData;
import top.r3944realms.lib39.core.sync.ISyncManager;

public abstract class CachedSyncManager<K, T extends ISyncData<?>>
implements ISyncManager<K, T> {
    private volatile Set<T> cachedSet;
    private volatile int mapSize = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<T> getSyncSet() {
        Map syncMap = this.getSyncMap();
        if (syncMap == null) {
            throw new IllegalStateException("SyncMap is not initialized");
        }
        if (this.cachedSet == null || this.mapSize != syncMap.size()) {
            CachedSyncManager cachedSyncManager = this;
            synchronized (cachedSyncManager) {
                if (this.cachedSet == null || this.mapSize != syncMap.size()) {
                    this.cachedSet = Set.copyOf(syncMap.values());
                    this.mapSize = syncMap.size();
                }
            }
        }
        return this.cachedSet;
    }

    protected void invalidateCache() {
        this.cachedSet = null;
        this.mapSize = -1;
    }

    @Override
    public void track(K key, T instance) {
        Map syncMap = this.getSyncMap();
        if (syncMap == null) {
            throw new IllegalStateException("SyncMap is not initialized");
        }
        syncMap.put(key, instance);
        this.invalidateCache();
    }

    @Override
    public void untrack(K key, T instance) {
        Map syncMap = this.getSyncMap();
        if (syncMap == null) {
            throw new IllegalStateException("SyncMap is not initialized");
        }
        syncMap.remove(key, instance);
        this.invalidateCache();
    }

    @Override
    public void clear() {
        Map syncMap = this.getSyncMap();
        if (syncMap != null) {
            syncMap.clear();
        }
        this.invalidateCache();
    }
}

