/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.sync;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import top.r3944realms.lib39.core.sync.ISyncData;

public interface ISyncManager<K, T extends ISyncData<?>> {
    public Map<K, T> getSyncMap();

    default public Set<T> getSyncSet() {
        Map<K, T> syncMap = this.getSyncMap();
        return Set.copyOf(syncMap.values());
    }

    default public void track(K key, T instance) {
        Map<K, T> syncMap = this.getSyncMap();
        if (syncMap == null) {
            throw new IllegalStateException("SyncMap is not initialized");
        }
        syncMap.put(key, instance);
    }

    default public void untrack(K key, T instance) {
        Map<K, T> syncMap = this.getSyncMap();
        if (syncMap == null) {
            throw new IllegalStateException("SyncMap is not initialized");
        }
        syncMap.remove(key, instance);
    }

    default public void foreach(Consumer<T> consumer) {
        Map<K, T> syncMap = this.getSyncMap();
        if (syncMap == null) {
            throw new IllegalStateException("SyncMap is not initialized");
        }
        syncMap.values().forEach(consumer);
    }

    default public void trackAll(Map<K, T> instances) {
        Map<K, T> syncMap = this.getSyncMap();
        if (syncMap == null) {
            throw new IllegalStateException("SyncMap is not initialized");
        }
        syncMap.putAll(instances);
    }

    default public int size() {
        Map<K, T> syncMap = this.getSyncMap();
        return syncMap != null ? syncMap.size() : 0;
    }

    default public boolean containsKey(K key) {
        Map<K, T> syncMap = this.getSyncMap();
        return syncMap != null && syncMap.containsKey(key);
    }

    default public boolean containsValue(T value) {
        Map<K, T> syncMap = this.getSyncMap();
        return syncMap != null && syncMap.containsValue(value);
    }

    default public void clear() {
        Map<K, T> syncMap = this.getSyncMap();
        if (syncMap != null) {
            syncMap.clear();
        }
    }
}

