/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.sync;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.lib39.core.network.NetworkHandler;
import top.r3944realms.lib39.core.network.toClient.SyncNBTCapDataEntityS2CPack;
import top.r3944realms.lib39.core.sync.IEntity;
import top.r3944realms.lib39.core.sync.ISyncData;

public abstract class NBTEntitySyncData
implements IEntity,
ISyncData<NBTEntitySyncData>,
INBTSerializable<CompoundTag> {
    protected boolean dirty;
    protected final ResourceLocation id;

    protected NBTEntitySyncData(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void copyFrom(@NotNull NBTEntitySyncData src) {
        this.dirty = src.isDirty();
    }

    @Override
    public void checkIfDirtyThenUpdate() {
        if (this.isDirty()) {
            NetworkHandler.sendToAllPlayer(new SyncNBTCapDataEntityS2CPack(this.entityId(), this.id(), (CompoundTag)this.serializeNBT()));
        }
        this.dirty = false;
    }
}

