/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.sync;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.lib39.core.sync.ISyncData;
import top.r3944realms.lib39.core.sync.ISyncManager;

public class SyncData2CapManager {
    private final Map<ResourceLocation, TypedSyncEntry<?, ?>> typedEntries = Maps.newConcurrentMap();

    public <K, T extends ISyncData<?>> void registerManager(ResourceLocation key, ISyncManager<K, T> manager, Capability<T> capability) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(manager, "Sync manager cannot be null");
        Objects.requireNonNull(capability, "Capability cannot be null");
        this.typedEntries.put(key, new TypedSyncEntry<K, T>(manager, capability));
    }

    public void registerManager(ResourceLocation key, ISyncManager<?, ? extends ISyncData<?>> manager) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(manager, "Sync manager cannot be null");
        this.typedEntries.put(key, new TypedSyncEntry(manager, null));
    }

    public <K, T extends ISyncData<?>> Optional<ISyncManager<K, T>> getManager(ResourceLocation key) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        return entry != null ? Optional.of(entry.manager) : Optional.empty();
    }

    public <T extends ISyncData<?>> Optional<Capability<T>> getCapability(ResourceLocation key) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null && entry.capability != null) {
            return Optional.of(entry.capability);
        }
        return Optional.empty();
    }

    public final void allowEntityClass(ResourceLocation key, Class<?> ... classes) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(classes, "Classes array cannot be null");
        if (classes.length == 0) {
            return;
        }
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null) {
            entry.allowedClasses.addAll(Arrays.asList(classes));
        }
    }

    public final void disallowEntityClass(ResourceLocation key, Class<?> ... classes) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(classes, "Classes array cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null && classes.length > 0) {
            Arrays.asList(classes).forEach(entry.allowedClasses::remove);
        }
    }

    public <T extends ISyncData<?>> void bindCapability(ResourceLocation key, Capability<T> capability) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(capability, "Capability cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry == null) {
            throw new IllegalArgumentException("No manager found for " + key);
        }
        this.updateCapabilityInEntry(key, entry, capability);
    }

    public void unbindCapability(ResourceLocation key) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null) {
            this.updateCapabilityInEntry(key, entry, null);
        }
    }

    public void clearAllowedEntityClasses(ResourceLocation key) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null) {
            entry.allowedClasses.clear();
        }
    }

    public boolean isEntityClassAllowed(ResourceLocation key, Class<?> entityClass) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(entityClass, "Entity class cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        boolean isAllowed = false;
        if (entry != null) {
            for (Class<?> allowedClass : entry.allowedClasses) {
                if (!entityClass.isAssignableFrom(allowedClass)) continue;
                isAllowed = true;
                break;
            }
        }
        return entry != null && isAllowed;
    }

    public void trackEntityForManager(Entity entity, ResourceLocation managerId) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(managerId);
        if (entry != null) {
            this.trackEntityWithTypedEntry(entity, entry);
        }
    }

    private <T extends ISyncData<?>> void trackEntityWithTypedEntry(Entity entity, @NotNull TypedSyncEntry<UUID, T> entry) {
        if (entry.capability != null) {
            entity.getCapability(entry.capability).ifPresent(cap -> entry.manager.track(entity.getUUID(), (ISyncData)cap));
        }
    }

    public void untrackEntityForManager(Entity entity, ResourceLocation managerId) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(managerId);
        if (entry != null) {
            this.untrackEntityWithTypedEntry(entity, entry);
        }
    }

    private <T extends ISyncData<?>> void untrackEntityWithTypedEntry(Entity entity, @NotNull TypedSyncEntry<UUID, T> entry) {
        if (entry.capability != null) {
            entity.getCapability(entry.capability).ifPresent(cap -> entry.manager.untrack(entity.getUUID(), (ISyncData)cap));
        }
    }

    public void untrackEntityFromAllManagers(Entity entity) {
        for (ResourceLocation id : this.getRegisteredKeys()) {
            if (!this.isEntityClassAllowed(id, entity.getClass())) continue;
            this.untrackEntityForManager(entity, id);
        }
    }

    public void untrackEntitiesForManager(@NotNull Iterable<Entity> entities, ResourceLocation managerId) {
        for (Entity entity : entities) {
            this.untrackEntityForManager(entity, managerId);
        }
    }

    public void untrackEntitiesFromAllManagers(@NotNull Iterable<Entity> entities) {
        for (Entity entity : entities) {
            this.untrackEntityFromAllManagers(entity);
        }
    }

    public void clearAllTrackedData(ResourceLocation managerId) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(managerId);
        if (entry != null) {
            this.clearTrackedDataForEntry(entry);
        }
    }

    private <K, T extends ISyncData<?>> void clearTrackedDataForEntry(@NotNull TypedSyncEntry<K, T> entry) {
        Set syncSet = entry.manager.getSyncSet();
        if (syncSet != null) {
            syncSet.clear();
        }
    }

    public void clearAllTrackedData() {
        for (ResourceLocation id : this.getRegisteredKeys()) {
            this.clearAllTrackedData(id);
        }
    }

    private <K, T extends ISyncData<?>> void updateCapabilityInEntry(ResourceLocation id, TypedSyncEntry<?, ?> entry, Capability<T> newCapability) {
        TypedSyncEntry<?, ?> typedEntry = entry;
        typedEntry.capability = newCapability;
        this.typedEntries.computeIfPresent(id, (resourceLocation, typedSyncEntry) -> typedEntry);
    }

    public Set<ResourceLocation> getRegisteredKeys() {
        return Collections.unmodifiableSet(this.typedEntries.keySet());
    }

    public void forEach(BiConsumer<ResourceLocation, ISyncManager<?, ?>> consumer) {
        Objects.requireNonNull(consumer, "Consumer cannot be null");
        this.typedEntries.forEach((? super K key, ? super V entry) -> consumer.accept((ResourceLocation)key, entry.manager));
    }

    public int getManagerCount() {
        return this.typedEntries.size();
    }

    public void clearAll() {
        this.typedEntries.clear();
    }

    public void removeManager(ResourceLocation key) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        this.typedEntries.remove(key);
    }

    private static class TypedSyncEntry<K, T extends ISyncData<?>> {
        final ISyncManager<K, T> manager;
        @Nullable
        Capability<T> capability;
        final Set<Class<?>> allowedClasses;

        TypedSyncEntry(ISyncManager<K, T> manager, @Nullable Capability<T> capability) {
            this.manager = manager;
            this.capability = capability;
            this.allowedClasses = Sets.newConcurrentHashSet();
        }
    }
}

