/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.core.sync;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.lib39.core.sync.ISyncData;
import top.r3944realms.lib39.core.sync.ISyncManager;

public class SyncData2Manager {
    private final Map<ResourceLocation, TypedSyncEntry<?, ?>> typedEntries = Maps.newConcurrentMap();

    public <K, T extends ISyncData<?>> void registerManagerWithProvider(ResourceLocation key, ISyncManager<K, T> manager, DataProvider<Entity, T> dataProvider) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(manager, "Sync manager cannot be null");
        Objects.requireNonNull(dataProvider, "Data provider cannot be null");
        this.typedEntries.put(key, new TypedSyncEntry<K, T>(manager, dataProvider));
    }

    public <K, T extends ISyncData<?>> void registerManager(ResourceLocation key, ISyncManager<K, T> manager, Function<Entity, Optional<T>> getter) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(manager, "Sync manager cannot be null");
        Objects.requireNonNull(getter, "Data getter function cannot be null");
        this.typedEntries.put(key, new TypedSyncEntry<K, T>(manager, getter::apply));
    }

    public void registerManager(ResourceLocation key, ISyncManager<?, ? extends ISyncData<?>> manager) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(manager, "Sync manager cannot be null");
        this.typedEntries.put(key, new TypedSyncEntry(manager, null));
    }

    public <K, T extends ISyncData<?>> Optional<ISyncManager<K, T>> getManager(ResourceLocation key) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        return entry != null ? Optional.of(entry.manager) : Optional.empty();
    }

    public <T extends ISyncData<?>> Optional<DataProvider<Entity, T>> getDataProvider(ResourceLocation key) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null && entry.dataProvider != null) {
            return Optional.of(entry.dataProvider);
        }
        return Optional.empty();
    }

    public <T extends ISyncData<?>> Optional<T> getEntityData(ResourceLocation key, Entity entity) {
        return this.getDataProvider(key).flatMap(provider -> {
            Optional result = provider.getData(entity);
            return result;
        });
    }

    public final void allowEntityClass(ResourceLocation key, Class<?> ... classes) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(classes, "Classes array cannot be null");
        if (classes.length == 0) {
            return;
        }
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null) {
            entry.allowedClasses.addAll(Arrays.asList(classes));
        }
    }

    public final void disallowEntityClass(ResourceLocation key, Class<?> ... classes) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(classes, "Classes array cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null && classes.length > 0) {
            Arrays.asList(classes).forEach(entry.allowedClasses::remove);
        }
    }

    public <T extends ISyncData<?>> void bindDataProvider(ResourceLocation key, DataProvider<Entity, T> dataProvider) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(dataProvider, "Data provider cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry == null) {
            throw new IllegalArgumentException("No manager found for " + key);
        }
        this.updateDataProviderInEntry(key, entry, dataProvider);
    }

    public <T extends ISyncData<?>> void bindDataGetter(ResourceLocation key, Function<Entity, Optional<T>> getter) {
        this.bindDataProvider(key, getter::apply);
    }

    public void unbindDataProvider(ResourceLocation key) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null) {
            this.updateDataProviderInEntry(key, entry, null);
        }
    }

    public void clearAllowedEntityClasses(ResourceLocation key) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry != null) {
            entry.allowedClasses.clear();
        }
    }

    public boolean isEntityClassAllowed(ResourceLocation key, Class<?> entityClass) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        Objects.requireNonNull(entityClass, "Entity class cannot be null");
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(key);
        if (entry == null) {
            return false;
        }
        if (entry.allowedClasses.isEmpty()) {
            return true;
        }
        return entry.allowedClasses.stream().anyMatch(allowedClass -> allowedClass.isAssignableFrom(entityClass));
    }

    public void trackEntityForManager(Entity entity, ResourceLocation managerId) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(managerId);
        if (entry != null) {
            this.trackEntityWithTypedEntry(entity, entry);
        }
    }

    private <T extends ISyncData<?>> void trackEntityWithTypedEntry(Entity entity, @NotNull TypedSyncEntry<UUID, T> entry) {
        if (entry.dataProvider != null) {
            entry.dataProvider.getData(entity).ifPresent(data -> entry.manager.track(entity.getUUID(), (ISyncData)data));
        }
    }

    public void untrackEntityForManager(Entity entity, ResourceLocation managerId) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(managerId);
        if (entry != null) {
            this.untrackEntityWithTypedEntry(entity, entry);
        }
    }

    private <T extends ISyncData<?>> void untrackEntityWithTypedEntry(Entity entity, @NotNull TypedSyncEntry<UUID, T> entry) {
        if (entry.dataProvider != null) {
            entry.dataProvider.getData(entity).ifPresent(data -> entry.manager.untrack(entity.getUUID(), (ISyncData)data));
        }
    }

    public void untrackEntityFromAllManagers(Entity entity) {
        for (ResourceLocation id : this.getRegisteredKeys()) {
            if (!this.isEntityClassAllowed(id, entity.getClass())) continue;
            this.untrackEntityForManager(entity, id);
        }
    }

    public void untrackEntitiesForManager(@NotNull Iterable<Entity> entities, ResourceLocation managerId) {
        for (Entity entity : entities) {
            this.untrackEntityForManager(entity, managerId);
        }
    }

    public void untrackEntitiesFromAllManagers(@NotNull Iterable<Entity> entities) {
        for (Entity entity : entities) {
            this.untrackEntityFromAllManagers(entity);
        }
    }

    public void clearAllTrackedData(ResourceLocation managerId) {
        TypedSyncEntry<?, ?> entry = this.typedEntries.get(managerId);
        if (entry != null) {
            this.clearTrackedDataForEntry(entry);
        }
    }

    private <K, T extends ISyncData<?>> void clearTrackedDataForEntry(@NotNull TypedSyncEntry<K, T> entry) {
        Set syncSet = entry.manager.getSyncSet();
        if (syncSet != null) {
            syncSet.clear();
        }
    }

    public void clearAllTrackedData() {
        for (ResourceLocation id : this.getRegisteredKeys()) {
            this.clearAllTrackedData(id);
        }
    }

    private <K, T extends ISyncData<?>> void updateDataProviderInEntry(ResourceLocation id, TypedSyncEntry<?, ?> entry, DataProvider<Entity, T> newDataProvider) {
        TypedSyncEntry newEntry = new TypedSyncEntry(entry.manager, newDataProvider);
        newEntry.allowedClasses.addAll(entry.allowedClasses);
        this.typedEntries.put(id, newEntry);
    }

    public Set<ResourceLocation> getRegisteredKeys() {
        return Collections.unmodifiableSet(this.typedEntries.keySet());
    }

    public void forEach(BiConsumer<ResourceLocation, ISyncManager<?, ?>> consumer) {
        Objects.requireNonNull(consumer, "Consumer cannot be null");
        this.typedEntries.forEach((? super K key, ? super V entry) -> consumer.accept((ResourceLocation)key, entry.manager));
    }

    public int getManagerCount() {
        return this.typedEntries.size();
    }

    public void clearAll() {
        this.typedEntries.clear();
    }

    public void removeManager(ResourceLocation key) {
        Objects.requireNonNull(key, "ResourceLocation key cannot be null");
        this.typedEntries.remove(key);
    }

    private static class TypedSyncEntry<K, T extends ISyncData<?>> {
        final ISyncManager<K, T> manager;
        @Nullable
        final DataProvider<Entity, T> dataProvider;
        final Set<Class<?>> allowedClasses;

        TypedSyncEntry(ISyncManager<K, T> manager, @Nullable DataProvider<Entity, T> dataProvider) {
            this.manager = manager;
            this.dataProvider = dataProvider;
            this.allowedClasses = Sets.newConcurrentHashSet();
        }
    }

    @FunctionalInterface
    public static interface DataProvider<K, T> {
        public Optional<T> getData(K var1);
    }
}

