/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.datagen.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.LanguageProvider;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.lib39.datagen.value.ILangKeyValue;
import top.r3944realms.lib39.datagen.value.ILangKeyValueCollection;
import top.r3944realms.lib39.datagen.value.McLocale;

public class SimpleLanguageProvider
extends LanguageProvider {
    private final McLocale language;
    private final ILangKeyValueCollection langKeyValueCollection;
    private final Map<String, String> translationMap;
    private final List<String> orderedKeys;

    public SimpleLanguageProvider(PackOutput output, String modId, @NotNull McLocale language, ILangKeyValueCollection langKeyValueCollection) {
        super(output, modId, language.mcCode());
        this.language = language;
        this.langKeyValueCollection = langKeyValueCollection;
        this.translationMap = new HashMap<String, String>();
        this.orderedKeys = new ArrayList<String>();
        this.initializeTranslations();
    }

    private void initializeTranslations() {
        for (ILangKeyValue iLangKeyValue : this.langKeyValueCollection.getValues()) {
            String key = iLangKeyValue.getKey();
            String value = iLangKeyValue.getLang(this.language);
            if (!this.translationMap.containsKey(key)) {
                this.orderedKeys.add(key);
            }
            this.translationMap.put(key, value);
        }
    }

    protected void addTranslations() {
        this.orderedKeys.forEach(key -> this.add((String)key, this.translationMap.get(key)));
        this.validateTranslations();
    }

    private void validateTranslations() {
        long addedCount = this.orderedKeys.stream().filter(this.translationMap::containsKey).count();
        LOGGER.info("Added {}/{} translations for {}", new Object[]{addedCount, this.orderedKeys.size(), this.language.mcCode()});
    }
}

