/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.datagen.value;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.lib39.datagen.value.ILangKeyValue;
import top.r3944realms.lib39.datagen.value.McLocale;
import top.r3944realms.lib39.datagen.value.ModPartEnum;

public class LangKeyValue
implements ILangKeyValue {
    protected final Supplier<?> supplier;
    protected final String key;
    protected final String US_EN;
    protected final String SIM_CN;
    protected final String TRA_CN;
    protected final String LZH;
    protected final Boolean Default;
    protected final ModPartEnum MPE;

    protected LangKeyValue(Builder builder) {
        this.supplier = builder.supplier;
        this.key = builder.key;
        this.MPE = builder.MPE;
        this.US_EN = builder.US_EN;
        this.SIM_CN = builder.SIM_CN;
        this.TRA_CN = builder.TRA_CN;
        this.LZH = builder.LZH;
        this.Default = builder.Default;
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Builder withSupplier(Supplier<?> supplier) {
        return new Builder().supplier(supplier);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Builder withKey(String key) {
        return new Builder().key(key);
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static LangKeyValue ofSupplier(Supplier<?> supplier, ModPartEnum MPE, String US_EN, String SIM_CN, String TRA_CN) {
        return LangKeyValue.builder().supplier(supplier).MPE(MPE).US_EN(US_EN).SIM_CN(SIM_CN).TRA_CN(TRA_CN).build();
    }

    @Contract(value="_, _, _, _, _, _ -> new", pure=true)
    @NotNull
    public static LangKeyValue ofSupplier(Supplier<?> supplier, ModPartEnum MPE, String US_EN, String SIM_CN, String TRA_CN, String LZH) {
        return LangKeyValue.builder().supplier(supplier).MPE(MPE).US_EN(US_EN).SIM_CN(SIM_CN).TRA_CN(TRA_CN).LZH(LZH).build();
    }

    @Contract(value="_, _, _, _, _, _, _ -> new", pure=true)
    @NotNull
    public static LangKeyValue ofSupplier(Supplier<?> supplier, ModPartEnum MPE, String US_EN, String SIM_CN, String TRA_CN, String LZH, boolean isDefault) {
        return LangKeyValue.builder().supplier(supplier).MPE(MPE).US_EN(US_EN).SIM_CN(SIM_CN).TRA_CN(TRA_CN).LZH(LZH).isDefault(isDefault).build();
    }

    @Contract(value="_, _, _, _, _, _ -> new", pure=true)
    @NotNull
    public static LangKeyValue ofSupplier(Supplier<?> supplier, ModPartEnum MPE, String US_EN, String SIM_CN, String TRA_CN, Boolean isDefault) {
        return LangKeyValue.builder().supplier(supplier).MPE(MPE).US_EN(US_EN).SIM_CN(SIM_CN).TRA_CN(TRA_CN).isDefault(isDefault).build();
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static LangKeyValue ofKey(String key, ModPartEnum MPE, String US_EN, String SIM_CN, String TRA_CN) {
        return LangKeyValue.builder().key(key).MPE(MPE).US_EN(US_EN).SIM_CN(SIM_CN).TRA_CN(TRA_CN).build();
    }

    @Contract(value="_, _, _, _, _, _ -> new", pure=true)
    @NotNull
    public static LangKeyValue ofKey(String key, ModPartEnum MPE, String US_EN, String SIM_CN, String TRA_CN, String LZH) {
        return LangKeyValue.builder().key(key).MPE(MPE).US_EN(US_EN).SIM_CN(SIM_CN).TRA_CN(TRA_CN).LZH(LZH).build();
    }

    @Contract(value="_, _, _, _, _, _ -> new", pure=true)
    @NotNull
    public static LangKeyValue ofKey(String key, ModPartEnum MPE, String US_EN, String SIM_CN, String TRA_CN, Boolean isDefault) {
        return LangKeyValue.builder().key(key).MPE(MPE).US_EN(US_EN).SIM_CN(SIM_CN).TRA_CN(TRA_CN).isDefault(isDefault).build();
    }

    @Override
    public String getKey() {
        return Objects.requireNonNullElseGet(this.key, () -> switch (this.MPE) {
            case ModPartEnum.ITEM -> this.getItem().getDescriptionId();
            case ModPartEnum.BLOCK -> this.getBlock().getDescriptionId();
            default -> throw new UnsupportedOperationException("The Key value is NULL! Please use the correct constructor and write the parameters correctly");
        });
    }

    @Override
    public String getLang(@NotNull McLocale locale) {
        return switch (locale) {
            default -> throw new IncompatibleClassChangeError();
            case McLocale.EN_US, McLocale.JA_JP, McLocale.KO_KR, McLocale.RU_RU, McLocale.DE_DE, McLocale.ES_ES, McLocale.FR_FR -> this.US_EN;
            case McLocale.ZH_CN -> this.SIM_CN;
            case McLocale.ZH_TW -> this.TRA_CN;
            case McLocale.LZH -> this.LZH != null ? this.LZH : this.TRA_CN;
        };
    }

    public Supplier<?> getSupplier() {
        return this.supplier;
    }

    public String getUS_EN() {
        return this.US_EN;
    }

    public String getSIM_CN() {
        return this.SIM_CN;
    }

    public String getTRA_CN() {
        return this.TRA_CN;
    }

    public String getLZH() {
        return this.LZH;
    }

    public Boolean isDefault() {
        return this.Default;
    }

    public ModPartEnum getMPE() {
        return this.MPE;
    }

    public Item getItem() throws IllegalArgumentException {
        if (this.MPE == ModPartEnum.ITEM) {
            return (Item)this.supplier.get();
        }
        throw new IllegalCallerException("Target's MPE is not ModPartEnum#ITEM.");
    }

    public Block getBlock() throws IllegalArgumentException {
        if (this.MPE == ModPartEnum.BLOCK) {
            return (Block)this.supplier.get();
        }
        throw new IllegalCallerException("Target's MPE is not ModPartEnum#BLOCK.");
    }

    public String toString() {
        return "LangKeyValue{key='" + this.key + "', US_EN='" + this.US_EN + "', SIM_CN='" + this.SIM_CN + "', MPE=" + this.MPE + "}";
    }

    public static class Builder {
        private Supplier<?> supplier;
        private String key;
        private ModPartEnum MPE;
        private String US_EN;
        private String SIM_CN;
        private String TRA_CN;
        private String LZH;
        private Boolean Default = false;

        @Contract(value="_ -> this")
        public Builder supplier(Supplier<?> supplier) {
            this.supplier = supplier;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder MPE(ModPartEnum MPE) {
            this.MPE = MPE;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder US_EN(String US_EN) {
            this.US_EN = US_EN;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder SIM_CN(String SIM_CN) {
            this.SIM_CN = SIM_CN;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder TRA_CN(String TRA_CN) {
            this.TRA_CN = TRA_CN;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder LZH(String LZH) {
            this.LZH = LZH;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder isDefault(Boolean isDefault) {
            this.Default = isDefault;
            return this;
        }

        @NotNull
        public LangKeyValue build() {
            if (this.MPE == null) {
                throw new IllegalStateException("MPE (ModPartEnum) is required");
            }
            if (this.US_EN == null) {
                throw new IllegalStateException("US_EN translation is required");
            }
            if (this.SIM_CN == null) {
                throw new IllegalStateException("SIM_CN translation is required");
            }
            if (this.TRA_CN == null) {
                throw new IllegalStateException("TRA_CN translation is required");
            }
            if (this.supplier == null && this.key == null) {
                throw new IllegalStateException("Either supplier or key must be provided");
            }
            if (this.supplier != null && this.key != null) {
                throw new IllegalStateException("Cannot provide both supplier and key");
            }
            return new LangKeyValue(this);
        }
    }
}

