/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.datagen.value;

import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public enum ModPartEnum {
    DEFAULT,
    ITEM(Item.class),
    BLOCK(Block.class),
    ENCHANTMENT,
    ADVANCEMENT_TITLE,
    ADVANCEMENT_DESCRIPTION,
    CREATIVE_TAB,
    CONFIG,
    ENTITY,
    GUI,
    PAINTING_TITLE,
    PAINTING_AUTHOR,
    TITLE,
    NAME,
    GAME_RULE,
    DESCRIPTION,
    INFO,
    MESSAGE,
    BIOME,
    COMMAND,
    SOUND;

    @Nullable
    private final Class<?> clazz;

    private ModPartEnum() {
        this.clazz = null;
    }

    private ModPartEnum(Class<?> clazz) {
        this.clazz = clazz;
    }

    public String getFullKey(String modId, String name) {
        return switch (this) {
            case ITEM -> "item." + modId + "." + name;
            case BLOCK -> "block." + modId + "." + name;
            case ENCHANTMENT -> "enchantment.";
            case ADVANCEMENT_TITLE -> "advancement." + modId + "." + name + ".title";
            case ADVANCEMENT_DESCRIPTION -> "advancement." + modId + "." + name + ".description";
            case CREATIVE_TAB -> "creativetab." + modId + "." + name;
            case BIOME -> "biome." + modId + "." + name;
            case CONFIG -> "config." + modId + "." + name;
            case ENTITY -> "entity." + modId + "." + name;
            case GUI -> "gui." + modId + "." + name;
            case PAINTING_AUTHOR -> "painting." + modId + "." + name + ".author";
            case PAINTING_TITLE -> "painting." + modId + "." + name + ".title";
            case TITLE -> "title." + modId + "." + name;
            case NAME -> "name." + modId + "." + name;
            case GAME_RULE -> "gamerule.";
            case DESCRIPTION -> "description.";
            case INFO -> "info." + modId + "." + name;
            case MESSAGE -> "message." + modId + "." + name;
            case COMMAND -> "command." + modId + "." + name;
            case SOUND -> "sound." + modId + "." + name;
            default -> modId + name;
        };
    }

    @Nullable
    public Class<?> getClazz() {
        return this.clazz;
    }
}

