/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.example.content.capability;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.lib39.example.content.capability.AbstractedTestSyncData;
import top.r3944realms.lib39.util.nbt.NBTReader;
import top.r3944realms.lib39.util.nbt.NBTWriter;

public class TestSyncData
extends AbstractedTestSyncData {
    public static final ResourceLocation ID = new ResourceLocation("lib39", "test_sync_data");
    private static final String NBT_KEY_STRING = "test_string";
    private static final String NBT_KEY_INT = "test_int";
    private static final String NBT_KEY_BOOLEAN = "test_boolean";
    private static final String NBT_KEY_DOUBLE = "test_double";
    private static final String NBT_KEY_COUNTER = "counter";
    private static final String NBT_KEY_SYNC_TIME = "last_sync_time";
    private static final String NBT_KEY_CUSTOM_DATA = "custom_data";
    private static final String NBT_KEY_CUSTOM_NAME = "name";
    private static final String NBT_KEY_CUSTOM_VALUE = "value";
    private static final String NBT_KEY_CUSTOM_FLAG = "flag";
    private String testString = "default_value";
    private int testInt = 42;
    private boolean testBoolean = true;
    private double testDouble = 3.14159;
    private int counter = 0;
    private long lastSyncTime = 0L;
    private AbstractedTestSyncData.TestData customData = new AbstractedTestSyncData.TestData("default", 100, false);
    private Entity self;

    public TestSyncData(Entity entity) {
        super(ID);
        this.self = entity;
    }

    public TestSyncData(int entityId, Entity self) {
        super(ID);
        this.self = self;
    }

    public TestSyncData(FriendlyByteBuf buf) {
        super(ID);
        this.self = null;
        this.fromBytes(buf);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUtf(this.testString != null ? this.testString : "");
        buf.writeInt(this.testInt);
        buf.writeBoolean(this.testBoolean);
        buf.writeDouble(this.testDouble);
        buf.writeInt(this.counter);
        buf.writeLong(this.lastSyncTime);
        if (this.customData != null) {
            buf.writeUtf(this.customData.getName() != null ? this.customData.getName() : "");
            buf.writeInt(this.customData.getValue());
            buf.writeBoolean(this.customData.isFlag());
        } else {
            buf.writeUtf("");
            buf.writeInt(0);
            buf.writeBoolean(false);
        }
        if (this.self != null) {
            buf.writeInt(this.self.getId());
        } else {
            buf.writeInt(-1);
        }
        buf.writeBoolean(this.isDirty());
    }

    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.testString = buf.readUtf(Short.MAX_VALUE);
        this.testInt = buf.readInt();
        this.testBoolean = buf.readBoolean();
        this.testDouble = buf.readDouble();
        this.counter = buf.readInt();
        this.lastSyncTime = buf.readLong();
        String customName = buf.readUtf();
        int customValue = buf.readInt();
        boolean customFlag = buf.readBoolean();
        this.customData = new AbstractedTestSyncData.TestData(customName, customValue, customFlag);
        int entityId = buf.readInt();
        boolean wasDirty = buf.readBoolean();
        if (wasDirty) {
            this.markDirty();
        }
    }

    public static TestSyncData staticFromBytes(FriendlyByteBuf buf) {
        return new TestSyncData(buf);
    }

    @Override
    public String getTestString() {
        return this.testString;
    }

    @Override
    public void setTestString(String value) {
        if (!Objects.equals(this.testString, value)) {
            this.testString = value;
            this.markDirty();
        }
    }

    @Override
    public int getTestInt() {
        return this.testInt;
    }

    @Override
    public void setTestInt(int value) {
        if (this.testInt != value) {
            this.testInt = value;
            this.markDirty();
        }
    }

    @Override
    public boolean isTestBoolean() {
        return this.testBoolean;
    }

    @Override
    public void setTestBoolean(boolean value) {
        if (this.testBoolean != value) {
            this.testBoolean = value;
            this.markDirty();
        }
    }

    @Override
    public double getTestDouble() {
        return this.testDouble;
    }

    @Override
    public void setTestDouble(double value) {
        if (this.testDouble != value) {
            this.testDouble = value;
            this.markDirty();
        }
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public void incrementCounter() {
        ++this.counter;
        this.markDirty();
    }

    @Override
    public long getLastSyncTime() {
        return this.lastSyncTime;
    }

    @Override
    public void updateSyncTime() {
        this.lastSyncTime = System.currentTimeMillis();
        this.markDirty();
    }

    @Override
    public AbstractedTestSyncData.TestData getCustomData() {
        return this.customData;
    }

    @Override
    public void setCustomData(AbstractedTestSyncData.TestData data) {
        if (data == null) {
            throw new IllegalArgumentException("Custom data cannot be null");
        }
        if (!Objects.equals(this.customData, data)) {
            this.customData = data;
            this.markDirty();
        }
    }

    @Override
    public boolean validateData() {
        return this.testString != null && !this.testString.isEmpty() && this.customData != null && this.customData.getName() != null && !this.customData.getName().isEmpty() && this.counter >= 0 && this.testInt >= 0;
    }

    public CompoundTag serializeNBT() {
        return NBTWriter.builder().string(NBT_KEY_STRING, this.testString).intValue(NBT_KEY_INT, this.testInt).booleanValue(NBT_KEY_BOOLEAN, this.testBoolean).doubleValue(NBT_KEY_DOUBLE, this.testDouble).intValue(NBT_KEY_COUNTER, this.counter).longValue(NBT_KEY_SYNC_TIME, this.lastSyncTime).compound(NBT_KEY_CUSTOM_DATA, NBTWriter.builder().string(NBT_KEY_CUSTOM_NAME, this.customData.getName()).intValue(NBT_KEY_CUSTOM_VALUE, this.customData.getValue()).booleanValue(NBT_KEY_CUSTOM_FLAG, this.customData.isFlag()).build()).build();
    }

    public void deserializeNBT(CompoundTag nbt) {
        NBTReader.of(nbt).intValue(NBT_KEY_INT, integer -> {
            this.testInt = integer;
        }).string(NBT_KEY_STRING, string -> {
            this.testString = string;
        }).booleanValue(NBT_KEY_BOOLEAN, bool -> {
            this.testBoolean = bool;
        }).intValue(NBT_KEY_COUNTER, integer -> {
            this.counter = integer;
        }).doubleValue(NBT_KEY_DOUBLE, dou -> {
            this.testDouble = dou;
        }).longValue(NBT_KEY_SYNC_TIME, sync -> {
            this.lastSyncTime = sync;
        }).compound(NBT_KEY_CUSTOM_DATA, customDataTag -> {
            AtomicReference<String> name = new AtomicReference<String>("");
            AtomicInteger value = new AtomicInteger(-1);
            AtomicBoolean flag = new AtomicBoolean(false);
            NBTReader.of(customDataTag).string(NBT_KEY_CUSTOM_NAME, name::set).intValue(NBT_KEY_CUSTOM_VALUE, value::set).booleanValue(NBT_KEY_CUSTOM_FLAG, flag::set);
            this.customData = new AbstractedTestSyncData.TestData(name.get(), value.get(), flag.get());
        });
    }

    @Override
    public int entityId() {
        return this.self != null ? this.self.getId() : -1;
    }

    public void setEntity(Entity entity) {
        this.self = entity;
    }

    public String toString() {
        return String.format("TestSyncData{id=%d, string='%s', int=%d, boolean=%s, double=%.2f, counter=%d, lastSync=%d, custom=%s}", this.self.getId(), this.testString, this.testInt, this.testBoolean, this.testDouble, this.counter, this.lastSyncTime, this.customData);
    }

    public void resetToDefaults() {
        this.testString = "default_value";
        this.testInt = 42;
        this.testBoolean = true;
        this.testDouble = 3.14159;
        this.counter = 0;
        this.lastSyncTime = 0L;
        this.customData = new AbstractedTestSyncData.TestData("default", 100, false);
        this.markDirty();
    }

    public void generateRandomData() {
        this.testString = "random_" + System.currentTimeMillis();
        this.testInt = (int)(Math.random() * 1000.0);
        this.testBoolean = Math.random() > 0.5;
        this.testDouble = Math.random() * 100.0;
        ++this.counter;
        this.lastSyncTime = System.currentTimeMillis();
        this.customData = new AbstractedTestSyncData.TestData("custom_" + this.counter, (int)(Math.random() * 500.0), Math.random() > 0.5);
        this.markDirty();
    }

    public TestSyncData createNetworkCopy() {
        TestSyncData copy = new TestSyncData((Entity)null);
        copy.testString = this.testString;
        copy.testInt = this.testInt;
        copy.testBoolean = this.testBoolean;
        copy.testDouble = this.testDouble;
        copy.counter = this.counter;
        copy.lastSyncTime = this.lastSyncTime;
        copy.customData = new AbstractedTestSyncData.TestData(this.customData.getName(), this.customData.getValue(), this.customData.isFlag());
        return copy;
    }
}

