/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.example.content.item;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.lib39.Lib39;
import top.r3944realms.lib39.example.content.capability.AbstractedTestSyncData;
import top.r3944realms.lib39.example.content.capability.ExCapabilityHandler;
import top.r3944realms.lib39.example.content.capability.TestSyncData;
import top.r3944realms.lib39.example.core.network.ClientDataPacket;
import top.r3944realms.lib39.example.core.network.ExNetworkHandler;

public class FabricItem
extends Item {
    public FabricItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            if (player.isShiftKeyDown()) {
                this.handleClientDualCheck(player);
            } else {
                this.handleClientSideQuery(player);
            }
        } else {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isShiftKeyDown()) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7b\u5f00\u59cb\u53cc\u7aef\u540c\u6b65\u68c0\u67e5\uff0c\u8bf7\u7b49\u5f85\u5ba2\u6237\u7aef\u6570\u636e..."));
            } else {
                this.handleServerSingleEndQuery(serverPlayer);
            }
            player.getCooldowns().addCooldown((Item)this, 20);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    private void handleClientDualCheck(Player player) {
        Entity targetEntity = this.getClientTargetedEntity(player);
        if (targetEntity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)targetEntity;
            TestSyncData clientData = this.getLocalClientData(livingTarget);
            if (clientData != null) {
                this.sendClientDataToServer(clientData, livingTarget.getId());
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7b\u5df2\u53d1\u9001\u5ba2\u6237\u7aef\u6570\u636e\u5230\u670d\u52a1\u5668\uff0c\u7b49\u5f85\u5bf9\u6bd4\u7ed3\u679c..."));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u65e0\u6cd5\u83b7\u53d6\u5ba2\u6237\u7aef\u672c\u5730\u6570\u636e"));
            }
        } else if (targetEntity == null && player.isShiftKeyDown()) {
            this.handlePlayerSelfData(player);
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u8bf7\u5bf9\u51c6\u4e00\u4e2a\u751f\u7269\u8fdb\u884c\u540c\u6b65\u68c0\u67e5\uff01"));
        }
    }

    private void handlePlayerSelfData(Player player) {
        TestSyncData clientData = this.getLocalClientData((LivingEntity)player);
        if (clientData != null) {
            this.sendClientDataToServer(clientData, player.getId());
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7b\u5df2\u53d1\u9001\u73a9\u5bb6\u81ea\u8eab\u5ba2\u6237\u7aef\u6570\u636e\u5230\u670d\u52a1\u5668\uff0c\u7b49\u5f85\u5bf9\u6bd4\u7ed3\u679c..."));
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u65e0\u6cd5\u83b7\u53d6\u73a9\u5bb6\u81ea\u8eab\u5ba2\u6237\u7aef\u6570\u636e"));
        }
    }

    private void handleClientSideQuery(Player player) {
        Entity targetEntity = this.getClientTargetedEntity(player);
        if (targetEntity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)targetEntity;
            TestSyncData clientData = this.getLocalClientData(livingTarget);
            if (clientData != null) {
                this.displayClientSideResults(player, livingTarget, clientData);
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u65e0\u6cd5\u67e5\u8be2\u5ba2\u6237\u7aef\u672c\u5730\u6570\u636e"));
            }
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u8bf7\u5bf9\u51c6\u4e00\u4e2a\u751f\u7269\u4f7f\u7528\uff01"));
        }
    }

    private void handleServerSingleEndQuery(ServerPlayer player) {
        Entity targetEntity = this.getServerTargetedEntity(player);
        if (targetEntity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)targetEntity;
            player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a7b\u5f00\u59cb\u67e5\u8be2 \u00a7e%s\u00a7b \u7684\u6570\u636e\uff0c3\u79d2\u540e\u663e\u793a\u7ed3\u679c...", livingTarget.getName().getString())));
            this.startServerSingleEndQuery(player, livingTarget);
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u8bf7\u5bf9\u51c6\u4e00\u4e2a\u751f\u7269\u4f7f\u7528\uff01"));
        }
    }

    private TestSyncData getLocalClientData(LivingEntity target) {
        try {
            AbstractedTestSyncData abstractData = target.getCapability(ExCapabilityHandler.TEST_CAP).resolve().orElse(null);
            if (abstractData instanceof TestSyncData) {
                return (TestSyncData)abstractData;
            }
        }
        catch (Exception e) {
            Lib39.LOGGER.error("[FabricItem] \u83b7\u53d6\u5ba2\u6237\u7aef\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private void sendClientDataToServer(TestSyncData clientData, int targetEntityId) {
        ExNetworkHandler.INSTANCE.sendToServer((Object)new ClientDataPacket(clientData, targetEntityId));
    }

    public static void handleClientDataFromPacket(@NotNull ServerPlayer player, TestSyncData clientData, int targetEntityId) {
        Entity target = player.level().getEntity(targetEntityId);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            TestSyncData serverData = FabricItem.getServerSideData(livingTarget);
            if (serverData != null) {
                FabricItem.displayDualEndComparison(player, livingTarget, serverData, clientData);
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u65e0\u6cd5\u83b7\u53d6\u670d\u52a1\u5668\u7aef\u6570\u636e"));
            }
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u76ee\u6807\u751f\u7269\u4e0d\u5b58\u5728\u6216\u5df2\u6d88\u5931"));
        }
    }

    @Nullable
    private static TestSyncData getServerSideData(LivingEntity target) {
        try {
            AbstractedTestSyncData abstractData = target.getCapability(ExCapabilityHandler.TEST_CAP).resolve().orElse(null);
            if (abstractData instanceof TestSyncData) {
                return (TestSyncData)abstractData;
            }
        }
        catch (Exception e) {
            Lib39.LOGGER.error("[FabricItem] \u83b7\u53d6\u670d\u52a1\u5668\u7aef\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private void startServerSingleEndQuery(ServerPlayer player, LivingEntity target) {
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(3000L);
                player.server.execute(() -> this.displayServerSingleEndResults(player, target));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Lib39.LOGGER.error("[FabricItem] \u6570\u636e\u67e5\u8be2\u88ab\u4e2d\u65ad", (Throwable)e);
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u6570\u636e\u67e5\u8be2\u88ab\u4e2d\u65ad"));
            }
            catch (Exception e) {
                Lib39.LOGGER.error("[FabricItem] \u6570\u636e\u67e5\u8be2\u51fa\u9519", (Throwable)e);
                player.server.execute(() -> player.sendSystemMessage((Component)Component.literal((String)("\u00a7c\u6570\u636e\u67e5\u8be2\u51fa\u9519: " + e.getMessage()))));
            }
        });
    }

    private void displayServerSingleEndResults(ServerPlayer player, @NotNull LivingEntity target) {
        Lib39.LOGGER.info("[FabricItem] \u67e5\u8be2\u751f\u7269 {} \u7684\u6570\u636e", (Object)target.getName().getString());
        AbstractedTestSyncData abstractData = this.getTestSyncData((Entity)target);
        if (abstractData instanceof TestSyncData) {
            TestSyncData testData = (TestSyncData)abstractData;
            this.displayServerDetailedData(player, target, testData);
        } else {
            player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a7c\u751f\u7269 \u00a7e%s\u00a7c \u6ca1\u6709\u6d4b\u8bd5\u6570\u636e\u6216\u6570\u636e\u65e0\u6548", target.getName().getString())));
        }
    }

    private void displayClientSideResults(Player player, LivingEntity target, TestSyncData clientData) {
        player.sendSystemMessage((Component)Component.literal((String)"\u00a76=== \u5ba2\u6237\u7aef\u6570\u636e\u67e5\u8be2\u7ed3\u679c ==="));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77\u76ee\u6807\u751f\u7269: \u00a7e" + target.getName().getString())));
        player.sendSystemMessage((Component)Component.literal((String)"\u00a77\u6570\u636e\u6765\u6e90: \u00a79\u5ba2\u6237\u7aef\u672c\u5730"));
        player.sendSystemMessage((Component)Component.literal((String)""));
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u57fa\u7840\u6570\u636e:"));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77\u5b57\u7b26\u4e32: \u00a7f" + clientData.getTestString())));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77\u6574\u6570\u503c: \u00a7f" + clientData.getTestInt())));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77\u5e03\u5c14\u503c: \u00a7f" + clientData.isTestBoolean())));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77\u53cc\u7cbe\u5ea6\u503c: \u00a7f" + String.format("%.2f", clientData.getTestDouble()))));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77\u8ba1\u6570\u5668: \u00a7f" + clientData.getCounter())));
        player.sendSystemMessage((Component)Component.literal((String)""));
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7e\u5ba2\u6237\u7aef\u72b6\u6001:"));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77\u6570\u636e\u9a8c\u8bc1: " + (clientData.validateData() ? "\u00a7a\u901a\u8fc7" : "\u00a7c\u5931\u8d25"))));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77\u540c\u6b65\u72b6\u6001: " + (clientData.isDirty() ? "\u00a76\u5f85\u540c\u6b65" : "\u00a7a\u5df2\u540c\u6b65"))));
    }

    private void displayServerDetailedData(ServerPlayer player, LivingEntity target, TestSyncData testData) {
        player.sendSystemMessage((Component)Component.literal((String)"\u00a76=== \u6570\u636e\u67e5\u8be2\u7ed3\u679c ==="));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u76ee\u6807\u751f\u7269: \u00a7e%s", target.getName().getString())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u5b9e\u4f53ID: \u00a7e%d", target.getId())));
        player.sendSystemMessage((Component)Component.literal((String)""));
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u57fa\u7840\u6570\u636e:"));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u5b57\u7b26\u4e32: \u00a7f%s", testData.getTestString())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u6574\u6570\u503c: \u00a7f%d", testData.getTestInt())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u5e03\u5c14\u503c: \u00a7f%s", testData.isTestBoolean())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u53cc\u7cbe\u5ea6\u503c: \u00a7f%.2f", testData.getTestDouble())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u8ba1\u6570\u5668: \u00a7f%d", testData.getCounter())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u6700\u540e\u540c\u6b65: \u00a7f%dms\u524d", System.currentTimeMillis() - testData.getLastSyncTime())));
        player.sendSystemMessage((Component)Component.literal((String)""));
        AbstractedTestSyncData.TestData customData = testData.getCustomData();
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u81ea\u5b9a\u4e49\u6570\u636e:"));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u540d\u79f0: \u00a7f%s", customData.getName())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u6570\u503c: \u00a7f%d", customData.getValue())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u6807\u5fd7: \u00a7f%s", customData.isFlag())));
        player.sendSystemMessage((Component)Component.literal((String)""));
        boolean isValid = testData.validateData();
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u6570\u636e\u9a8c\u8bc1: %s", isValid ? "\u00a7a\u901a\u8fc7" : "\u00a7c\u5931\u8d25")));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u6570\u636e\u72b6\u6001: %s", testData.isDirty() ? "\u00a76\u672a\u540c\u6b65" : "\u00a7a\u5df2\u540c\u6b65")));
    }

    private static void displayDualEndComparison(ServerPlayer player, LivingEntity target, TestSyncData serverData, TestSyncData clientData) {
        player.sendSystemMessage((Component)Component.literal((String)"\u00a76=== \u5ba2\u6237\u7aef-\u670d\u52a1\u5668\u53cc\u7aef\u540c\u6b65\u68c0\u67e5\u7ed3\u679c ==="));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u76ee\u6807\u751f\u7269: \u00a7e%s", target.getName().getString())));
        player.sendSystemMessage((Component)Component.literal((String)""));
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u6570\u636e\u6765\u6e90:"));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77- \u00a7c\u670d\u52a1\u5668\u7aef\u00a77: \u5b9e\u4f53ID " + serverData.entityId())));
        player.sendSystemMessage((Component)Component.literal((String)("\u00a77- \u00a79\u5ba2\u6237\u7aef\u00a77: \u5b9e\u4f53ID " + clientData.entityId())));
        player.sendSystemMessage((Component)Component.literal((String)""));
        boolean stringSynced = serverData.getTestString().equals(clientData.getTestString());
        boolean intSynced = serverData.getTestInt() == clientData.getTestInt();
        boolean booleanSynced = serverData.isTestBoolean() == clientData.isTestBoolean();
        boolean doubleSynced = Math.abs(serverData.getTestDouble() - clientData.getTestDouble()) < 0.001;
        boolean counterSynced = serverData.getCounter() == clientData.getCounter();
        boolean customDataSynced = FabricItem.compareCustomData(serverData.getCustomData(), clientData.getCustomData());
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u5b57\u6bb5\u540c\u6b65\u72b6\u6001:"));
        FabricItem.displayDualEndSyncStatus(player, "\u5b57\u7b26\u4e32", stringSynced, serverData.getTestString(), clientData.getTestString());
        FabricItem.displayDualEndSyncStatus(player, "\u6574\u6570\u503c", intSynced, serverData.getTestInt(), clientData.getTestInt());
        FabricItem.displayDualEndSyncStatus(player, "\u5e03\u5c14\u503c", booleanSynced, serverData.isTestBoolean(), clientData.isTestBoolean());
        FabricItem.displayDualEndSyncStatus(player, "\u53cc\u7cbe\u5ea6\u503c", doubleSynced, serverData.getTestDouble(), clientData.getTestDouble());
        FabricItem.displayDualEndSyncStatus(player, "\u8ba1\u6570\u5668", counterSynced, serverData.getCounter(), clientData.getCounter());
        FabricItem.displayDualEndSyncStatus(player, "\u81ea\u5b9a\u4e49\u6570\u636e", customDataSynced, serverData.getCustomData().toString(), clientData.getCustomData().toString());
        player.sendSystemMessage((Component)Component.literal((String)""));
        int totalFields = 6;
        int syncedFields = (stringSynced ? 1 : 0) + (intSynced ? 1 : 0) + (booleanSynced ? 1 : 0) + (doubleSynced ? 1 : 0) + (counterSynced ? 1 : 0) + (customDataSynced ? 1 : 0);
        double syncRate = (double)syncedFields / (double)totalFields * 100.0;
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u603b\u4f53\u540c\u6b65\u72b6\u6001:"));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u540c\u6b65\u5b57\u6bb5: \u00a7e%d\u00a77/\u00a7e%d", syncedFields, totalFields)));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u540c\u6b65\u7387: %s", FabricItem.getSyncRateColor(syncRate) + String.format("%.1f%%", syncRate))));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u540c\u6b65\u72b6\u6001: %s", FabricItem.getOverallSyncStatus(syncRate))));
        player.sendSystemMessage((Component)Component.literal((String)""));
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u6570\u636e\u72b6\u6001\u5dee\u5f02:"));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u670d\u52a1\u5668\u810f\u6570\u636e\u72b6\u6001: %s", serverData.isDirty() ? "\u00a76\u810f" : "\u00a7a\u5e72\u51c0")));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u5ba2\u6237\u7aef\u810f\u6570\u636e\u72b6\u6001: %s", clientData.isDirty() ? "\u00a76\u810f" : "\u00a7a\u5e72\u51c0")));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u670d\u52a1\u5668\u9a8c\u8bc1\u72b6\u6001: %s", serverData.validateData() ? "\u00a7a\u901a\u8fc7" : "\u00a7c\u5931\u8d25")));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u5ba2\u6237\u7aef\u9a8c\u8bc1\u72b6\u6001: %s", clientData.validateData() ? "\u00a7a\u901a\u8fc7" : "\u00a7c\u5931\u8d25")));
        player.sendSystemMessage((Component)Component.literal((String)""));
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7e\u540c\u6b65\u5efa\u8bae:"));
        if (syncRate == 100.0) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u2713 \u6570\u636e\u5b8c\u5168\u540c\u6b65\uff0c\u65e0\u9700\u64cd\u4f5c"));
        } else if (syncRate >= 80.0) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7e\u26a0 \u6570\u636e\u57fa\u672c\u540c\u6b65\uff0c\u5efa\u8bae\u89c2\u5bdf"));
        } else if (syncRate >= 50.0) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76\u26a0 \u6570\u636e\u90e8\u5206\u4e0d\u540c\u6b65\uff0c\u5efa\u8bae\u68c0\u67e5\u7f51\u7edc"));
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u2717 \u6570\u636e\u4e25\u91cd\u4e0d\u540c\u6b65\uff0c\u5efa\u8bae\u91cd\u65b0\u540c\u6b65"));
        }
    }

    private static void displayDualEndSyncStatus(ServerPlayer player, String fieldName, boolean synced, Object serverValue, Object clientValue) {
        String status;
        String string = status = synced ? "\u00a7a\u2713 \u540c\u6b65" : "\u00a7c\u2717 \u4e0d\u540c\u6b65";
        if (synced) {
            player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77%s: %s \u00a78(\u503c: \u00a77%s\u00a78)", fieldName, status, serverValue)));
        } else {
            player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77%s: %s", fieldName, status)));
            player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a78  \u00a7c\u670d\u52a1\u5668: \u00a77%s", serverValue)));
            player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a78  \u00a79\u5ba2\u6237\u7aef: \u00a77%s", clientValue)));
        }
    }

    private static boolean compareCustomData(AbstractedTestSyncData.TestData first, AbstractedTestSyncData.TestData second) {
        return first.getName().equals(second.getName()) && first.getValue() == second.getValue() && first.isFlag() == second.isFlag();
    }

    private static String getSyncRateColor(double syncRate) {
        if (syncRate >= 90.0) {
            return "\u00a7a";
        }
        if (syncRate >= 70.0) {
            return "\u00a7e";
        }
        if (syncRate >= 50.0) {
            return "\u00a76";
        }
        return "\u00a7c";
    }

    private static String getOverallSyncStatus(double syncRate) {
        if (syncRate == 100.0) {
            return "\u00a7a\u5b8c\u5168\u540c\u6b65";
        }
        if (syncRate >= 90.0) {
            return "\u00a7a\u4f18\u79c0\u540c\u6b65";
        }
        if (syncRate >= 70.0) {
            return "\u00a7e\u826f\u597d\u540c\u6b65";
        }
        if (syncRate >= 50.0) {
            return "\u00a76\u90e8\u5206\u540c\u6b65";
        }
        return "\u00a7c\u540c\u6b65\u8f83\u5dee";
    }

    private Entity getClientTargetedEntity(Player player) {
        double reachDistance = 20.0;
        float partialTicks = 1.0f;
        Vec3 eyePosition = player.getEyePosition(partialTicks);
        Vec3 lookVector = player.getViewVector(partialTicks);
        Vec3 endPosition = eyePosition.add(lookVector.x * reachDistance, lookVector.y * reachDistance, lookVector.z * reachDistance);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyePosition, (Vec3)endPosition, (AABB)player.getBoundingBox().expandTowards(lookVector.scale(reachDistance)).inflate(1.0), entity -> !entity.isSpectator() && entity.isPickable(), (double)(reachDistance * reachDistance));
        if (entityHit != null) {
            return entityHit.getEntity();
        }
        return null;
    }

    private Entity getServerTargetedEntity(ServerPlayer player) {
        double reachDistance = 20.0;
        float partialTicks = 1.0f;
        Vec3 eyePosition = player.getEyePosition(partialTicks);
        Vec3 lookVector = player.getViewVector(partialTicks);
        Vec3 endPosition = eyePosition.add(lookVector.x * reachDistance, lookVector.y * reachDistance, lookVector.z * reachDistance);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyePosition, (Vec3)endPosition, (AABB)player.getBoundingBox().expandTowards(lookVector.scale(reachDistance)).inflate(1.0), entity -> !entity.isSpectator() && entity.isPickable(), (double)(reachDistance * reachDistance));
        if (entityHit != null) {
            return entityHit.getEntity();
        }
        return null;
    }

    private AbstractedTestSyncData getTestSyncData(Entity entity) {
        try {
            return entity.getCapability(ExCapabilityHandler.TEST_CAP).resolve().orElse(null);
        }
        catch (Exception e) {
            Lib39.LOGGER.debug("[FabricItem] \u83b7\u53d6\u751f\u7269 {} \u7684 TestSyncData \u5931\u8d25: {}", (Object)entity.getName().getString(), (Object)e.getMessage());
            return null;
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, level, tooltip, flag);
        tooltip.add((Component)Component.literal((String)"\u00a77\u53f3\u952e\u70b9\u51fb\u5728 3 \u79d2\u540e\u6267\u884c"));
        tooltip.add((Component)Component.literal((String)"\u00a77\u00a7e\u51c6\u661f\u7784\u51c6\u751f\u7269\u00a77\u7684\u6570\u636e\u67e5\u8be2"));
        tooltip.add((Component)Component.literal((String)"\u00a77\u00a7oShift + \u53f3\u952e\u00a77\u8fdb\u884c\u00a7e\u5ba2\u6237\u7aef-\u670d\u52a1\u5668\u53cc\u7aef\u540c\u6b65\u68c0\u67e5\u00a77"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"\u00a76\u67e5\u8be2\u5ef6\u8fdf: \u00a7e3\u79d2"));
        tooltip.add((Component)Component.literal((String)"\u00a76\u7784\u51c6\u8ddd\u79bb: \u00a7e20\u683c"));
        tooltip.add((Component)Component.literal((String)"\u00a76\u51b7\u5374\u65f6\u95f4: \u00a7e1\u79d2"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"\u00a7a\u5355\u7aef\u67e5\u8be2\u5185\u5bb9:"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u57fa\u7840\u6570\u636e\u5b57\u6bb5"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u81ea\u5b9a\u4e49\u6570\u636e\u7ed3\u6784"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u6570\u636e\u9a8c\u8bc1\u72b6\u6001"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u540c\u6b65\u72b6\u6001\u4fe1\u606f"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"\u00a7e\u53cc\u7aef\u540c\u6b65\u68c0\u67e5:"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u5ba2\u6237\u7aef\u548c\u670d\u52a1\u5668\u540c\u65f6\u67e5\u8be2"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u5b57\u6bb5\u7ea7\u540c\u6b65\u72b6\u6001\u5bf9\u6bd4"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u603b\u4f53\u540c\u6b65\u7387\u8ba1\u7b97"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u53cc\u7aef\u6570\u636e\u72b6\u6001\u5dee\u5f02"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u540c\u6b65\u5efa\u8bae"));
    }
}

