/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.example.content.item;

import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.lib39.Lib39;
import top.r3944realms.lib39.example.content.capability.AbstractedTestSyncData;
import top.r3944realms.lib39.example.content.capability.ExCapabilityHandler;
import top.r3944realms.lib39.example.content.capability.TestSyncData;

public class NeoForgeItem
extends Item {
    private static final Random RANDOM = new Random();

    public NeoForgeItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isShiftKeyDown()) {
                this.handleSelfDataOperation(serverPlayer);
            } else {
                this.handleTargetDataOperation(serverPlayer);
            }
            player.getCooldowns().addCooldown((Item)this, 20);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    private void handleSelfDataOperation(ServerPlayer player) {
        boolean success = this.triggerRandomTransformation((LivingEntity)player);
        if (success) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u5df2\u89e6\u53d1\u00a7e\u81ea\u8eab\u00a7a\u6d4b\u8bd5\u6570\u636e\u7684\u968f\u673a\u53d8\u6362\uff01"));
            Lib39.LOGGER.info("[NeoForgeItem] \u73a9\u5bb6 {} \u89e6\u53d1\u4e86\u81ea\u8eab\u6570\u636e\u53d8\u6362", (Object)player.getName().getString());
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u65e0\u6cd5\u89e6\u53d1\u81ea\u8eab\u6570\u636e\u53d8\u6362"));
        }
    }

    private void handleTargetDataOperation(ServerPlayer player) {
        Entity targetEntity = this.getTargetedEntity(player);
        if (targetEntity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)targetEntity;
            boolean success = this.triggerRandomTransformation(livingTarget);
            if (success) {
                player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a7a\u5df2\u89e6\u53d1 \u00a7e%s\u00a7a \u7684\u6d4b\u8bd5\u6570\u636e\u968f\u673a\u53d8\u6362\uff01", livingTarget.getName().getString())));
                Lib39.LOGGER.info("[NeoForgeItem] \u73a9\u5bb6 {} \u89e6\u53d1\u751f\u7269 {} \u7684\u6570\u636e\u53d8\u6362", (Object)player.getName().getString(), (Object)livingTarget.getName().getString());
            } else {
                player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a7c\u65e0\u6cd5\u89e6\u53d1 \u00a7e%s\u00a7c \u7684\u6570\u636e\u53d8\u6362", livingTarget.getName().getString())));
            }
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7c\u8bf7\u5bf9\u51c6\u4e00\u4e2a\u751f\u7269\u4f7f\u7528\uff01"));
        }
    }

    private Entity getTargetedEntity(ServerPlayer player) {
        double reachDistance = 20.0;
        float partialTicks = 1.0f;
        Vec3 eyePosition = player.getEyePosition(partialTicks);
        Vec3 lookVector = player.getViewVector(partialTicks);
        Vec3 endPosition = eyePosition.add(lookVector.x * reachDistance, lookVector.y * reachDistance, lookVector.z * reachDistance);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyePosition, (Vec3)endPosition, (AABB)player.getBoundingBox().expandTowards(lookVector.scale(reachDistance)).inflate(1.0), entity -> !entity.isSpectator() && entity.isPickable(), (double)(reachDistance * reachDistance));
        if (entityHit != null) {
            return entityHit.getEntity();
        }
        return null;
    }

    private boolean triggerRandomTransformation(LivingEntity entity) {
        try {
            AbstractedTestSyncData abstractData = this.getOrCreateTestSyncData((Entity)entity);
            if (!(abstractData instanceof TestSyncData)) {
                return false;
            }
            TestSyncData testData = (TestSyncData)abstractData;
            int transformationType = RANDOM.nextInt(6);
            switch (transformationType) {
                case 0: {
                    testData.generateRandomData();
                    Lib39.LOGGER.debug("[NeoForgeItem] \u4e3a {} \u751f\u6210\u5b8c\u5168\u968f\u673a\u6570\u636e", (Object)this.getEntityName(entity));
                    break;
                }
                case 1: {
                    testData.setTestString("transformed_" + System.currentTimeMillis());
                    testData.incrementCounter();
                    testData.updateSyncTime();
                    Lib39.LOGGER.debug("[NeoForgeItem] \u4e3a {} \u4fee\u6539\u5b57\u7b26\u4e32\u548c\u8ba1\u6570\u5668", (Object)this.getEntityName(entity));
                    break;
                }
                case 2: {
                    testData.setTestInt(RANDOM.nextInt(1000));
                    testData.setTestDouble(RANDOM.nextDouble() * 100.0);
                    testData.setTestBoolean(RANDOM.nextBoolean());
                    testData.updateSyncTime();
                    Lib39.LOGGER.debug("[NeoForgeItem] \u4e3a {} \u4fee\u6539\u6570\u503c\u6570\u636e", (Object)this.getEntityName(entity));
                    break;
                }
                case 3: {
                    AbstractedTestSyncData.TestData newCustomData = new AbstractedTestSyncData.TestData("custom_" + RANDOM.nextInt(100), RANDOM.nextInt(500), RANDOM.nextBoolean());
                    testData.setCustomData(newCustomData);
                    testData.incrementCounter();
                    Lib39.LOGGER.debug("[NeoForgeItem] \u4e3a {} \u4fee\u6539\u81ea\u5b9a\u4e49\u6570\u636e", (Object)this.getEntityName(entity));
                    break;
                }
                case 4: {
                    testData.resetToDefaults();
                    Lib39.LOGGER.debug("[NeoForgeItem] \u4e3a {} \u91cd\u7f6e\u6570\u636e", (Object)this.getEntityName(entity));
                    break;
                }
                case 5: {
                    if (entity instanceof Player) {
                        testData.setTestString("player_special_" + entity.getUUID().toString().substring(0, 8));
                        testData.setTestInt(entity.getId() * 10);
                        testData.setTestDouble(entity.getHealth());
                        testData.incrementCounter();
                        testData.updateSyncTime();
                        Lib39.LOGGER.debug("[NeoForgeItem] \u4e3a\u73a9\u5bb6 {} \u8bbe\u7f6e\u4e13\u5c5e\u6570\u636e", (Object)this.getEntityName(entity));
                        break;
                    }
                    testData.generateRandomData();
                }
            }
            if (!testData.validateData()) {
                Lib39.LOGGER.warn("[NeoForgeItem] {} \u7684\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u503c", (Object)this.getEntityName(entity));
                testData.resetToDefaults();
            }
            if (entity instanceof Player) {
                this.displayDataPreview((Player)entity, testData);
            }
            return true;
        }
        catch (Exception e) {
            Lib39.LOGGER.error("[NeoForgeItem] \u4e3a {} \u89e6\u53d1\u6570\u636e\u53d8\u6362\u65f6\u51fa\u9519: {}", (Object)this.getEntityName(entity), (Object)e.getMessage());
            return false;
        }
    }

    private void displayDataPreview(Player player, TestSyncData testData) {
        player.sendSystemMessage((Component)Component.literal((String)"\u00a76\u6570\u636e\u9884\u89c8:"));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u5b57\u7b26\u4e32: \u00a7f%s", testData.getTestString())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u8ba1\u6570\u5668: \u00a7f%d", testData.getCounter())));
        player.sendSystemMessage((Component)Component.literal((String)String.format("\u00a77\u9a8c\u8bc1\u72b6\u6001: %s", testData.validateData() ? "\u00a7a\u901a\u8fc7" : "\u00a7c\u5931\u8d25")));
    }

    private String getEntityName(LivingEntity entity) {
        if (entity instanceof Player) {
            return "\u73a9\u5bb6 " + entity.getName().getString();
        }
        return "\u751f\u7269 " + entity.getName().getString();
    }

    private AbstractedTestSyncData getOrCreateTestSyncData(Entity entity) {
        try {
            return (AbstractedTestSyncData)entity.getCapability(ExCapabilityHandler.TEST_CAP).resolve().orElseThrow();
        }
        catch (Exception e) {
            Lib39.LOGGER.error("[NeoForgeItem] \u83b7\u53d6 {} \u7684 TestSyncData \u5931\u8d25: {}", (Object)this.getEntityName((LivingEntity)entity), (Object)e.getMessage());
            return null;
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, level, tooltip, flag);
        tooltip.add((Component)Component.literal((String)"\u00a77\u53f3\u952e\u70b9\u51fb\u89e6\u53d1\u00a7e\u51c6\u661f\u7784\u51c6\u751f\u7269\u00a77\u7684"));
        tooltip.add((Component)Component.literal((String)"\u00a77\u6d4b\u8bd5\u6570\u636e\u968f\u673a\u53d8\u6362"));
        tooltip.add((Component)Component.literal((String)"\u00a77\u00a7oShift + \u53f3\u952e\u00a77\u64cd\u4f5c\u00a7e\u81ea\u8eab\u00a77\u6570\u636e"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"\u00a76\u51b7\u5374\u65f6\u95f4: \u00a7e1\u79d2"));
        tooltip.add((Component)Component.literal((String)"\u00a76\u7784\u51c6\u8ddd\u79bb: \u00a7e20\u683c"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"\u00a7a\u53d8\u6362\u7c7b\u578b:"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u5b8c\u5168\u968f\u673a\u6570\u636e"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u5b57\u7b26\u4e32+\u8ba1\u6570\u5668"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u6570\u503c\u6570\u636e"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u81ea\u5b9a\u4e49\u6570\u636e"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u91cd\u7f6e\u9ed8\u8ba4\u503c"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u73a9\u5bb6\u4e13\u5c5e\u6570\u636e"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.literal((String)"\u00a7e\u81ea\u8eab\u64cd\u4f5c\u7279\u6027:"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u663e\u793a\u6570\u636e\u9884\u89c8"));
        tooltip.add((Component)Component.literal((String)"\u00a77- \u73a9\u5bb6\u4e13\u5c5e\u6570\u636e\u53d8\u6362"));
    }
}

