/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.example.core.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import top.r3944realms.lib39.example.content.capability.TestSyncData;
import top.r3944realms.lib39.example.content.item.FabricItem;

public class ClientDataPacket {
    private final TestSyncData clientData;
    private final int targetEntityId;

    public ClientDataPacket(TestSyncData clientData, int targetEntityId) {
        this.clientData = clientData;
        this.targetEntityId = targetEntityId;
    }

    public ClientDataPacket(FriendlyByteBuf buf) {
        this.clientData = TestSyncData.staticFromBytes(buf);
        this.targetEntityId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.clientData.toBytes(buf);
        buf.writeInt(this.targetEntityId);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                this.handleClientData(player, this.clientData, this.targetEntityId);
            }
        });
        context.setPacketHandled(true);
    }

    private void handleClientData(ServerPlayer player, TestSyncData clientData, int targetEntityId) {
        FabricItem.handleClientDataFromPacket(player, clientData, targetEntityId);
    }
}

