/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.example.datagen.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import top.r3944realms.lib39.datagen.value.LangKeyValue;
import top.r3944realms.lib39.datagen.value.ModPartEnum;
import top.r3944realms.lib39.example.datagen.data.ExLib39LangKeys;

public class ExItemModelProvider
extends ItemModelProvider {
    private static List<Item> objectList;
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";

    public ExItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "lib39", existingFileHelper);
        objectList = new ArrayList<Item>();
        this.init();
    }

    protected void registerModels() {
        this.DefaultModItemModelRegister();
    }

    private void init() {
        for (LangKeyValue obj : ExLib39LangKeys.INSTANCE.getValues()) {
            if (!obj.isDefault().booleanValue() || !obj.getMPE().equals((Object)ModPartEnum.ITEM)) continue;
            objectList.add(obj.getItem());
        }
    }

    private void DefaultModItemModelRegister() {
        objectList.forEach(arg_0 -> ((ExItemModelProvider)this).basicItem(arg_0));
    }

    public void itemGenerateModel(Item item, ResourceLocation location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", location);
    }

    public void itemHandHeldModel(Item item, ResourceLocation location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), HANDHELD)).texture("layer0", location);
    }

    public String itemName(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).getPath();
    }

    public ResourceLocation resourceItem(String path) {
        return this.modLoc("item/" + path);
    }
}

