/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.block;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.r3944realms.lib39.core.event.CommonEventHandler;

public class BlockRegistryBuilder {
    private String registryName;
    private RegistryObject<Block> blockObject;

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static BlockRegistryBuilder create() {
        return new BlockRegistryBuilder();
    }

    public BlockRegistryBuilder withName(String name) {
        this.registryName = name;
        return this;
    }

    public BlockRegistryBuilder registerBlock(@NotNull DeferredRegister<Block> blockRegister, Supplier<? extends Block> blockSupplier) {
        this.blockObject = blockRegister.register(this.registryName, blockSupplier);
        return this;
    }

    @SafeVarargs
    private void registerBlockItem(RegistryObject<Block> blockObject, ResourceKey<CreativeModeTab> ... creativeTabs) {
        CommonEventHandler.Mod.addItemToTabs(blockObject, creativeTabs);
    }

    public BlockRegistryBuilder registerWithBuildingTab(DeferredRegister<Block> blockRegister, Supplier<? extends Block> blockSupplier) {
        this.registerBlock(blockRegister, blockSupplier);
        this.registerBlockItem(this.blockObject, CreativeModeTabs.BUILDING_BLOCKS);
        return this;
    }

    public BlockRegistryBuilder registerWithFunctionalTab(DeferredRegister<Block> blockRegister, Supplier<? extends Block> blockSupplier) {
        this.registerBlock(blockRegister, blockSupplier);
        this.registerBlockItem(this.blockObject, CreativeModeTabs.FUNCTIONAL_BLOCKS);
        return this;
    }

    public RegistryObject<Block> build() {
        return this.blockObject;
    }
}

