/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandAliasHelper {
    public static void registerWithAliases(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, LiteralArgumentBuilder<CommandSourceStack> mainCommand, String ... aliases) {
        LiteralCommandNode mainNode = dispatcher.register(mainCommand);
        for (String alias : aliases) {
            LiteralArgumentBuilder aliasCommand = Commands.literal((String)alias);
            CommandAliasHelper.copyChildren((CommandNode<CommandSourceStack>)mainNode, aliasCommand);
            dispatcher.register(aliasCommand);
        }
    }

    private static void copyChildren(@NotNull CommandNode<CommandSourceStack> source, ArgumentBuilder<CommandSourceStack, ?> target) {
        for (CommandNode child : source.getChildren()) {
            ArgumentBuilder<CommandSourceStack, ?> childBuilder = CommandAliasHelper.createBuilderFromNode((CommandNode<CommandSourceStack>)child);
            if (childBuilder == null) continue;
            CommandAliasHelper.copyChildren((CommandNode<CommandSourceStack>)child, childBuilder);
            target.then(childBuilder);
        }
    }

    @Nullable
    private static ArgumentBuilder<CommandSourceStack, ?> createBuilderFromNode(CommandNode<CommandSourceStack> node) {
        if (node instanceof LiteralCommandNode) {
            LiteralCommandNode literalNode = (LiteralCommandNode)node;
            LiteralArgumentBuilder builder = Commands.literal((String)literalNode.getLiteral());
            CommandAliasHelper.copyNodeProperties(node, builder);
            return builder;
        }
        if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentNode = (ArgumentCommandNode)node;
            RequiredArgumentBuilder builder = Commands.argument((String)argumentNode.getName(), (ArgumentType)argumentNode.getType());
            if (argumentNode.getCustomSuggestions() != null) {
                builder.suggests(argumentNode.getCustomSuggestions());
            }
            CommandAliasHelper.copyNodeProperties(node, builder);
            return builder;
        }
        return null;
    }

    private static void copyNodeProperties(@NotNull CommandNode<CommandSourceStack> source, ArgumentBuilder<CommandSourceStack, ?> target) {
        if (source.getRedirect() != null) {
            target.redirect(source.getRedirect());
        }
        if (source.getRequirement() != null) {
            target.requires(source.getRequirement());
        }
        if (source.getCommand() != null) {
            target.executes(source.getCommand());
        }
    }
}

