/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.lang;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Pair<F, S> {
    public F first;
    public S second;

    private Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    @Contract(value="null, _ -> fail; !null, null -> fail; !null, !null -> new")
    @NotNull
    public static <F, S> Pair<F, S> of(F first, S second) {
        if (first == null || second == null) {
            throw new IllegalArgumentException("Pair.of requires non-null argument");
        }
        return new Pair<F, S>(first, second);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair rhs = (Pair)obj;
        return this.first.equals(rhs.first) && this.second.equals(rhs.second);
    }

    public int hashCode() {
        return this.first.hashCode() * 37 + this.second.hashCode();
    }

    public String toString() {
        return "Pair{first=" + this.first + ", second=" + this.second + "}";
    }
}

