/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.lang;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Triple<A, B, C> {
    public A first;
    public B second;
    public C third;

    private Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <A, B, C> Triple<A, B, C> of(A first, B second, C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triple triple = (Triple)o;
        return Objects.equals(this.first, triple.first) && Objects.equals(this.second, triple.second) && Objects.equals(this.third, triple.third);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "Triple{first=" + this.first + ", second=" + this.second + ", third=" + this.third + "}";
    }
}

