/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.lang;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Tuple {
    private final List<Object> elements;

    private Tuple(Object ... elements) {
        this.elements = List.of(elements);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Tuple of(Object ... elements) {
        return new Tuple(elements);
    }

    public int size() {
        return this.elements.size();
    }

    public <T> T get(int index) {
        if (index < 0 || index >= this.elements.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.elements.size());
        }
        return (T)this.elements.get(index);
    }

    public <T> T first() {
        return this.get(0);
    }

    public <T> T second() {
        return this.get(1);
    }

    public <T> T third() {
        return this.get(2);
    }

    public <T> T last() {
        return this.get(this.elements.size() - 1);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public List<Object> toList() {
        return new ArrayList<Object>(this.elements);
    }

    @Contract(pure=true)
    public Object @NotNull [] toArray() {
        return this.elements.toArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Objects.equals(this.elements, tuple.elements);
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "Tuple" + this.elements;
    }

    @NotNull
    public Iterator<Object> iterator() {
        return this.elements.iterator();
    }

    public Stream<Object> stream() {
        return this.elements.stream();
    }
}

