/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.nbt;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTReader {
    private final CompoundTag nbt;

    private NBTReader(CompoundTag nbt) {
        this.nbt = nbt;
    }

    @NotNull
    public static NBTReader of(@NotNull CompoundTag nbt) {
        return new NBTReader(nbt);
    }

    public NBTReader string(String key, Consumer<String> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getString(key));
        }
        return this;
    }

    public NBTReader string(String key, @NotNull Consumer<String> setter, String defaultValue) {
        setter.accept(this.nbt.contains(key) ? this.nbt.getString(key) : defaultValue);
        return this;
    }

    public NBTReader byteValue(String key, Consumer<Byte> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getByte(key));
        }
        return this;
    }

    public NBTReader byteValue(String key, @NotNull Consumer<Byte> setter, byte defaultValue) {
        setter.accept(this.nbt.contains(key) ? this.nbt.getByte(key) : defaultValue);
        return this;
    }

    public NBTReader shortValue(String key, Consumer<Short> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getShort(key));
        }
        return this;
    }

    public NBTReader shortValue(String key, @NotNull Consumer<Short> setter, short defaultValue) {
        setter.accept(this.nbt.contains(key) ? this.nbt.getShort(key) : defaultValue);
        return this;
    }

    public NBTReader intValue(String key, Consumer<Integer> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getInt(key));
        }
        return this;
    }

    public NBTReader intValue(String key, @NotNull Consumer<Integer> setter, int defaultValue) {
        setter.accept(this.nbt.contains(key) ? this.nbt.getInt(key) : defaultValue);
        return this;
    }

    public NBTReader longValue(String key, Consumer<Long> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getLong(key));
        }
        return this;
    }

    public NBTReader longValue(String key, @NotNull Consumer<Long> setter, long defaultValue) {
        setter.accept(this.nbt.contains(key) ? this.nbt.getLong(key) : defaultValue);
        return this;
    }

    public NBTReader floatValue(String key, Consumer<Float> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(Float.valueOf(this.nbt.getFloat(key)));
        }
        return this;
    }

    public NBTReader floatValue(String key, @NotNull Consumer<Float> setter, float defaultValue) {
        setter.accept(Float.valueOf(this.nbt.contains(key) ? this.nbt.getFloat(key) : defaultValue));
        return this;
    }

    public NBTReader doubleValue(String key, Consumer<Double> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getDouble(key));
        }
        return this;
    }

    public NBTReader doubleValue(String key, @NotNull Consumer<Double> setter, double defaultValue) {
        setter.accept(this.nbt.contains(key) ? this.nbt.getDouble(key) : defaultValue);
        return this;
    }

    public NBTReader booleanValue(String key, Consumer<Boolean> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getBoolean(key));
        }
        return this;
    }

    public NBTReader booleanValue(String key, @NotNull Consumer<Boolean> setter, boolean defaultValue) {
        setter.accept(this.nbt.contains(key) ? this.nbt.getBoolean(key) : defaultValue);
        return this;
    }

    public NBTReader byteArray(String key, Consumer<byte[]> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getByteArray(key));
        }
        return this;
    }

    public NBTReader intArray(String key, Consumer<int[]> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getIntArray(key));
        }
        return this;
    }

    public NBTReader longArray(String key, Consumer<long[]> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getLongArray(key));
        }
        return this;
    }

    public NBTReader uuid(String key, Consumer<UUID> setter) {
        if (this.nbt.hasUUID(key)) {
            setter.accept(this.nbt.getUUID(key));
        }
        return this;
    }

    public NBTReader uuid(String key, @NotNull Consumer<UUID> setter, UUID defaultValue) {
        setter.accept(this.nbt.hasUUID(key) ? this.nbt.getUUID(key) : defaultValue);
        return this;
    }

    public NBTReader compound(String key, Consumer<CompoundTag> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getCompound(key));
        }
        return this;
    }

    public NBTReader compound(String key, @NotNull Consumer<CompoundTag> setter, CompoundTag defaultValue) {
        setter.accept(this.nbt.contains(key) ? this.nbt.getCompound(key) : defaultValue);
        return this;
    }

    public NBTReader list(String key, int type, Consumer<ListTag> setter) {
        if (this.nbt.contains(key)) {
            setter.accept(this.nbt.getList(key, type));
        }
        return this;
    }

    public NBTReader vec3(String key, Consumer<Vec3> setter) {
        CompoundTag vecTag;
        if (this.nbt.contains(key) && (vecTag = this.nbt.getCompound(key)).contains("X") && vecTag.contains("Y") && vecTag.contains("Z")) {
            setter.accept(new Vec3(vecTag.getDouble("X"), vecTag.getDouble("Y"), vecTag.getDouble("Z")));
        }
        return this;
    }

    public NBTReader vec3(String key, Consumer<Vec3> setter, Vec3 defaultValue) {
        CompoundTag vecTag;
        if (this.nbt.contains(key) && (vecTag = this.nbt.getCompound(key)).contains("X") && vecTag.contains("Y") && vecTag.contains("Z")) {
            setter.accept(new Vec3(vecTag.getDouble("X"), vecTag.getDouble("Y"), vecTag.getDouble("Z")));
            return this;
        }
        setter.accept(defaultValue);
        return this;
    }

    public <T extends Enum<T>> NBTReader enumValue(String key, Class<T> enumClass, Consumer<T> setter) {
        if (this.nbt.contains(key)) {
            String value = this.nbt.getString(key);
            try {
                setter.accept(Enum.valueOf(enumClass, value.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this;
    }

    public <T extends Enum<T>> NBTReader enumValue(String key, Class<T> enumClass, Consumer<T> setter, T defaultValue) {
        if (this.nbt.contains(key)) {
            String value = this.nbt.getString(key);
            try {
                setter.accept(Enum.valueOf(enumClass, value.toUpperCase()));
                return this;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        setter.accept(defaultValue);
        return this;
    }

    public NBTReader nested(String key, Consumer<NBTReader> consumer) {
        if (this.nbt.contains(key)) {
            consumer.accept(new NBTReader(this.nbt.getCompound(key)));
        }
        return this;
    }

    public NBTReader nested(String key, Consumer<NBTReader> consumer, Runnable orElse) {
        if (this.nbt.contains(key)) {
            consumer.accept(new NBTReader(this.nbt.getCompound(key)));
        } else {
            orElse.run();
        }
        return this;
    }

    public NBTReader ifPresent(String key, Runnable action) {
        if (this.nbt.contains(key)) {
            action.run();
        }
        return this;
    }

    public NBTReader ifAbsent(String key, Runnable action) {
        if (!this.nbt.contains(key)) {
            action.run();
        }
        return this;
    }

    @NotNull
    public CompoundTag getRaw() {
        return this.nbt;
    }

    @NotNull
    public static Vec3 readVec3(@NotNull CompoundTag nbt) {
        if (nbt.contains("X") && nbt.contains("Y") && nbt.contains("Z")) {
            return new Vec3(nbt.getDouble("X"), nbt.getDouble("Y"), nbt.getDouble("Z"));
        }
        throw new IllegalArgumentException("NBT is missing X, Y, or Z value for Vec3");
    }

    @Nullable
    public static Vec3 readVec3Safe(@NotNull CompoundTag nbt) {
        if (nbt.contains("X") && nbt.contains("Y") && nbt.contains("Z")) {
            return new Vec3(nbt.getDouble("X"), nbt.getDouble("Y"), nbt.getDouble("Z"));
        }
        return null;
    }
}

