/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.nbt;

import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTWriter {
    private final CompoundTag root;

    private NBTWriter() {
        this.root = new CompoundTag();
    }

    private NBTWriter(CompoundTag existingTag) {
        this.root = existingTag;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static NBTWriter builder() {
        return new NBTWriter();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static NBTWriter of(CompoundTag existingTag) {
        return new NBTWriter(existingTag);
    }

    public NBTWriter byteValue(String key, byte value) {
        this.root.putByte(key, value);
        return this;
    }

    public NBTWriter shortValue(String key, short value) {
        this.root.putShort(key, value);
        return this;
    }

    public NBTWriter intValue(String key, int value) {
        this.root.putInt(key, value);
        return this;
    }

    public NBTWriter longValue(String key, long value) {
        this.root.putLong(key, value);
        return this;
    }

    public NBTWriter floatValue(String key, float value) {
        this.root.putFloat(key, value);
        return this;
    }

    public NBTWriter doubleValue(String key, double value) {
        this.root.putDouble(key, value);
        return this;
    }

    public NBTWriter booleanValue(String key, boolean value) {
        this.root.putBoolean(key, value);
        return this;
    }

    public NBTWriter string(String key, String value) {
        if (value != null) {
            this.root.putString(key, value);
        }
        return this;
    }

    public NBTWriter string(String key, String value, String defaultValue) {
        if (value != null) {
            this.root.putString(key, value);
        } else if (defaultValue != null) {
            this.root.putString(key, defaultValue);
        }
        return this;
    }

    public NBTWriter byteValue(String key, Byte value) {
        if (value != null) {
            this.root.putByte(key, value.byteValue());
        }
        return this;
    }

    public NBTWriter byteValue(String key, Byte value, byte defaultValue) {
        this.root.putByte(key, value != null ? value : defaultValue);
        return this;
    }

    public NBTWriter shortValue(String key, Short value) {
        if (value != null) {
            this.root.putShort(key, value.shortValue());
        }
        return this;
    }

    public NBTWriter shortValue(String key, Short value, short defaultValue) {
        this.root.putShort(key, value != null ? value : defaultValue);
        return this;
    }

    public NBTWriter intValue(String key, Integer value) {
        if (value != null) {
            this.root.putInt(key, value.intValue());
        }
        return this;
    }

    public NBTWriter intValue(String key, Integer value, int defaultValue) {
        this.root.putInt(key, value != null ? value : defaultValue);
        return this;
    }

    public NBTWriter longValue(String key, Long value) {
        if (value != null) {
            this.root.putLong(key, value.longValue());
        }
        return this;
    }

    public NBTWriter longValue(String key, Long value, long defaultValue) {
        this.root.putLong(key, value != null ? value : defaultValue);
        return this;
    }

    public NBTWriter floatValue(String key, Float value) {
        if (value != null) {
            this.root.putFloat(key, value.floatValue());
        }
        return this;
    }

    public NBTWriter floatValue(String key, Float value, float defaultValue) {
        this.root.putFloat(key, value != null ? value.floatValue() : defaultValue);
        return this;
    }

    public NBTWriter doubleValue(String key, Double value) {
        if (value != null) {
            this.root.putDouble(key, value.doubleValue());
        }
        return this;
    }

    public NBTWriter doubleValue(String key, Double value, double defaultValue) {
        this.root.putDouble(key, value != null ? value : defaultValue);
        return this;
    }

    public NBTWriter booleanValue(String key, Boolean value) {
        if (value != null) {
            this.root.putBoolean(key, value.booleanValue());
        }
        return this;
    }

    public NBTWriter booleanValue(String key, Boolean value, boolean defaultValue) {
        this.root.putBoolean(key, value != null ? value : defaultValue);
        return this;
    }

    public NBTWriter byteArray(String key, byte[] value) {
        if (value != null) {
            this.root.putByteArray(key, value);
        }
        return this;
    }

    public NBTWriter intArray(String key, int[] value) {
        if (value != null) {
            this.root.putIntArray(key, value);
        }
        return this;
    }

    public NBTWriter longArray(String key, long[] value) {
        if (value != null) {
            this.root.putLongArray(key, value);
        }
        return this;
    }

    public NBTWriter uuid(String key, UUID value) {
        if (value != null) {
            this.root.putUUID(key, value);
        }
        return this;
    }

    public NBTWriter uuid(String key, UUID value, UUID defaultValue) {
        if (value != null) {
            this.root.putUUID(key, value);
        } else if (defaultValue != null) {
            this.root.putUUID(key, defaultValue);
        }
        return this;
    }

    public NBTWriter compound(String key, Consumer<NBTWriter> consumer) {
        if (consumer != null) {
            NBTWriter nestedBuilder = new NBTWriter();
            consumer.accept(nestedBuilder);
            CompoundTag nestedTag = nestedBuilder.build();
            if (!nestedTag.isEmpty()) {
                this.root.put(key, (Tag)nestedTag);
            }
        }
        return this;
    }

    public NBTWriter compound(String key, CompoundTag compoundTag) {
        if (compoundTag != null && !compoundTag.isEmpty()) {
            this.root.put(key, (Tag)compoundTag);
        }
        return this;
    }

    public NBTWriter compoundIf(String key, boolean condition, Consumer<NBTWriter> consumer) {
        if (condition && consumer != null) {
            return this.compound(key, consumer);
        }
        return this;
    }

    public NBTWriter list(String key, Consumer<ListNBTBuilder> consumer) {
        if (consumer != null) {
            ListNBTBuilder listBuilder = new ListNBTBuilder();
            consumer.accept(listBuilder);
            ListTag listTag = listBuilder.build();
            if (!listTag.isEmpty()) {
                this.root.put(key, (Tag)listTag);
            }
        }
        return this;
    }

    public NBTWriter list(String key, ListTag listTag) {
        if (listTag != null && !listTag.isEmpty()) {
            this.root.put(key, (Tag)listTag);
        }
        return this;
    }

    public NBTWriter listIf(String key, boolean condition, Consumer<ListNBTBuilder> consumer) {
        if (condition && consumer != null) {
            return this.list(key, consumer);
        }
        return this;
    }

    public NBTWriter tag(String key, Tag tag) {
        if (tag != null) {
            this.root.put(key, tag);
        }
        return this;
    }

    public NBTWriter stringIf(String key, String value, boolean condition) {
        if (condition && value != null) {
            this.root.putString(key, value);
        }
        return this;
    }

    public NBTWriter intValueIf(String key, Integer value, boolean condition) {
        if (condition && value != null) {
            this.root.putInt(key, value.intValue());
        }
        return this;
    }

    public NBTWriter longValueIf(String key, Long value, boolean condition) {
        if (condition && value != null) {
            this.root.putLong(key, value.longValue());
        }
        return this;
    }

    public NBTWriter booleanValueIf(String key, Boolean value, boolean condition) {
        if (condition && value != null) {
            this.root.putBoolean(key, value.booleanValue());
        }
        return this;
    }

    public NBTWriter remove(String key) {
        this.root.remove(key);
        return this;
    }

    public CompoundTag build() {
        return this.root;
    }

    public static CompoundTag create(Consumer<NBTWriter> consumer) {
        NBTWriter builder = new NBTWriter();
        if (consumer != null) {
            consumer.accept(builder);
        }
        return builder.build();
    }

    public static ListTag createList(Consumer<ListNBTBuilder> consumer) {
        ListNBTBuilder builder = new ListNBTBuilder();
        if (consumer != null) {
            consumer.accept(builder);
        }
        return builder.build();
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public Set<String> getAllKeys() {
        return this.root.getAllKeys();
    }

    @Contract(value="null -> fail")
    @NotNull
    public static CompoundTag writeVec3(Vec3 vec) {
        CompoundTag nbt = new CompoundTag();
        if (vec == null) {
            throw new IllegalArgumentException("Vec3 cannot be null");
        }
        nbt.putDouble("X", vec.x);
        nbt.putDouble("Y", vec.y);
        nbt.putDouble("Z", vec.z);
        return nbt;
    }

    @Nullable
    public static CompoundTag writeVec3Safe(Vec3 vec) {
        CompoundTag nbt = new CompoundTag();
        if (vec == null) {
            return null;
        }
        nbt.putDouble("X", vec.x);
        nbt.putDouble("Y", vec.y);
        nbt.putDouble("Z", vec.z);
        return nbt;
    }

    public static class ListNBTBuilder {
        private final ListTag list = new ListTag();

        private ListNBTBuilder() {
        }

        public ListNBTBuilder addString(String value) {
            this.list.add((Object)StringTag.valueOf((String)value));
            return this;
        }

        public ListNBTBuilder addByte(byte value) {
            this.list.add((Object)ByteTag.valueOf((byte)value));
            return this;
        }

        public ListNBTBuilder addShort(short value) {
            this.list.add((Object)ShortTag.valueOf((short)value));
            return this;
        }

        public ListNBTBuilder addInt(int value) {
            this.list.add((Object)IntTag.valueOf((int)value));
            return this;
        }

        public ListNBTBuilder addLong(long value) {
            this.list.add((Object)LongTag.valueOf((long)value));
            return this;
        }

        public ListNBTBuilder addFloat(float value) {
            this.list.add((Object)FloatTag.valueOf((float)value));
            return this;
        }

        public ListNBTBuilder addDouble(double value) {
            this.list.add((Object)DoubleTag.valueOf((double)value));
            return this;
        }

        public ListNBTBuilder addBoolean(boolean value) {
            this.list.add((Object)ByteTag.valueOf((boolean)value));
            return this;
        }

        public ListNBTBuilder addByteArray(byte[] value) {
            if (value != null) {
                this.list.add((Object)new ByteArrayTag(value));
            }
            return this;
        }

        public ListNBTBuilder addIntArray(int[] value) {
            if (value != null) {
                this.list.add((Object)new IntArrayTag(value));
            }
            return this;
        }

        public ListNBTBuilder addLongArray(long[] value) {
            if (value != null) {
                this.list.add((Object)new LongArrayTag(value));
            }
            return this;
        }

        public ListNBTBuilder addString(String value, String defaultValue) {
            this.list.add((Object)StringTag.valueOf((String)(value != null ? value : defaultValue)));
            return this;
        }

        public ListNBTBuilder addStringIf(String value) {
            if (value != null) {
                this.list.add((Object)StringTag.valueOf((String)value));
            }
            return this;
        }

        public ListNBTBuilder addByte(Byte value) {
            if (value != null) {
                this.list.add((Object)ByteTag.valueOf((byte)value));
            }
            return this;
        }

        public ListNBTBuilder addByte(Byte value, byte defaultValue) {
            this.list.add((Object)ByteTag.valueOf((byte)(value != null ? value : defaultValue)));
            return this;
        }

        public ListNBTBuilder addShort(Short value) {
            if (value != null) {
                this.list.add((Object)ShortTag.valueOf((short)value));
            }
            return this;
        }

        public ListNBTBuilder addShort(Short value, short defaultValue) {
            this.list.add((Object)ShortTag.valueOf((short)(value != null ? value : defaultValue)));
            return this;
        }

        public ListNBTBuilder addInt(Integer value) {
            if (value != null) {
                this.list.add((Object)IntTag.valueOf((int)value));
            }
            return this;
        }

        public ListNBTBuilder addInt(Integer value, int defaultValue) {
            this.list.add((Object)IntTag.valueOf((int)(value != null ? value : defaultValue)));
            return this;
        }

        public ListNBTBuilder addLong(Long value) {
            if (value != null) {
                this.list.add((Object)LongTag.valueOf((long)value));
            }
            return this;
        }

        public ListNBTBuilder addLong(Long value, long defaultValue) {
            this.list.add((Object)LongTag.valueOf((long)(value != null ? value : defaultValue)));
            return this;
        }

        public ListNBTBuilder addFloat(Float value) {
            if (value != null) {
                this.list.add((Object)FloatTag.valueOf((float)value.floatValue()));
            }
            return this;
        }

        public ListNBTBuilder addFloat(Float value, float defaultValue) {
            this.list.add((Object)FloatTag.valueOf((float)(value != null ? value.floatValue() : defaultValue)));
            return this;
        }

        public ListNBTBuilder addDouble(Double value) {
            if (value != null) {
                this.list.add((Object)DoubleTag.valueOf((double)value));
            }
            return this;
        }

        public ListNBTBuilder addDouble(Double value, double defaultValue) {
            this.list.add((Object)DoubleTag.valueOf((double)(value != null ? value : defaultValue)));
            return this;
        }

        public ListNBTBuilder addBoolean(Boolean value) {
            if (value != null) {
                this.list.add((Object)ByteTag.valueOf((boolean)value));
            }
            return this;
        }

        public ListNBTBuilder addBoolean(Boolean value, boolean defaultValue) {
            this.list.add((Object)ByteTag.valueOf((boolean)(value != null ? value : defaultValue)));
            return this;
        }

        public ListNBTBuilder addCompound(Consumer<NBTWriter> consumer) {
            if (consumer != null) {
                NBTWriter compoundBuilder = new NBTWriter();
                consumer.accept(compoundBuilder);
                CompoundTag compoundTag = compoundBuilder.build();
                if (!compoundTag.isEmpty()) {
                    this.list.add((Object)compoundTag);
                }
            }
            return this;
        }

        public ListNBTBuilder addTag(Tag tag) {
            if (tag != null) {
                this.list.add((Object)tag);
            }
            return this;
        }

        public ListNBTBuilder addIf(boolean condition, Consumer<ListNBTBuilder> consumer) {
            if (condition && consumer != null) {
                consumer.accept(this);
            }
            return this;
        }

        public ListTag build() {
            return this.list;
        }
    }
}

