/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.riding;

import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import top.r3944realms.lib39.Lib39;
import top.r3944realms.lib39.util.riding.RidingCycleException;
import top.r3944realms.lib39.util.riding.RidingRelationship;
import top.r3944realms.lib39.util.riding.RidingSerializer;
import top.r3944realms.lib39.util.riding.RidingValidator;

public class RidingApplier {
    public static int applyRidingRelationship(RidingRelationship relationship, Function<UUID, Entity> entityProvider) {
        if (relationship == null || entityProvider == null) {
            return 0;
        }
        int appliedCount = 0;
        LinkedList<RidingRelationship> queue = new LinkedList<RidingRelationship>();
        queue.offer(relationship);
        while (!queue.isEmpty()) {
            Entity vehicle;
            RidingRelationship current = (RidingRelationship)queue.poll();
            UUID entityId = current.getEntityId();
            UUID vehicleId = current.getVehicleId();
            Entity entity = entityProvider.apply(entityId);
            Entity entity2 = vehicle = vehicleId != null ? entityProvider.apply(vehicleId) : null;
            if (entity == null) continue;
            if (vehicle != null) {
                for (RidingRelationship child : current.getPassengers()) {
                    child.setVehicleId(vehicle.getUUID());
                    queue.offer(child);
                }
            }
            ++appliedCount;
            if (entity.getVehicle() != null) {
                entity.stopRiding();
            }
            if (vehicle != null) {
                if (RidingValidator.wouldCreateCycle(entity, vehicle)) {
                    throw new RidingCycleException(entityId, vehicleId);
                }
                boolean success = entity.startRiding(vehicle, true);
                if (!success) {
                    Lib39.LOGGER.error("Failed to mount entity {} to vehicle {}", (Object)entityId, (Object)vehicleId);
                }
            }
            queue.addAll(current.getPassengers());
        }
        return appliedCount;
    }

    public static void applyRidingRelationships(Collection<RidingRelationship> relationships, Function<UUID, Entity> entityProvider) {
        if (relationships == null || relationships.isEmpty()) {
            return;
        }
        for (RidingRelationship relationship : relationships) {
            try {
                RidingApplier.applyRidingRelationship(relationship, entityProvider);
            }
            catch (RidingCycleException e) {
                Lib39.LOGGER.warn("Cyclic riding reference detected and skipped: {}", (Object)e.getMessage());
            }
        }
    }

    public static int applyRidingRelationshipFromJson(String json, Function<UUID, Entity> entityProvider) {
        RidingRelationship relationship = RidingSerializer.deserialize(json);
        return RidingApplier.applyRidingRelationship(relationship, entityProvider);
    }
}

