/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.riding;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import top.r3944realms.lib39.util.riding.RidingFinder;
import top.r3944realms.lib39.util.riding.RidingRelationship;

public class RidingDismounts {
    public static void dismountEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.isPassenger()) {
            entity.stopRiding();
        }
        RidingDismounts.dismountAllPassengers(entity);
    }

    public static void dismountAllPassengers(Entity entity) {
        if (entity == null) {
            return;
        }
        LinkedList<Entity> queue = new LinkedList<Entity>();
        queue.offer(entity);
        while (!queue.isEmpty()) {
            Entity current = (Entity)queue.poll();
            ArrayList passengers = new ArrayList(current.getPassengers());
            for (Entity passenger : passengers) {
                passenger.stopRiding();
                queue.offer(passenger);
            }
        }
    }

    public static void dismountRootEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        Entity rootVehicle = RidingFinder.findRootVehicle(entity);
        if (rootVehicle != null) {
            RidingDismounts.dismountAllPassengers(rootVehicle);
            if (rootVehicle.isPassenger()) {
                rootVehicle.stopRiding();
            }
        }
    }

    public static boolean safeDismountAll(Entity entity, int maxIterations) {
        if (entity == null) {
            return true;
        }
        int iteration = 0;
        LinkedList<Entity> queue = new LinkedList<Entity>();
        queue.offer(entity);
        while (!queue.isEmpty() && iteration < maxIterations) {
            Entity current = (Entity)queue.poll();
            ++iteration;
            if (current.isPassenger()) {
                current.stopRiding();
            }
            ArrayList passengers = new ArrayList(current.getPassengers());
            for (Entity passenger : passengers) {
                passenger.stopRiding();
                queue.offer(passenger);
            }
        }
        return queue.isEmpty();
    }

    public static void dismountEntities(Collection<Entity> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        HashSet<Entity> processed = new HashSet<Entity>();
        LinkedList<Entity> queue = new LinkedList<Entity>(entities);
        while (!queue.isEmpty()) {
            Entity current = (Entity)queue.poll();
            if (current == null || processed.contains(current)) continue;
            processed.add(current);
            if (current.isPassenger()) {
                current.stopRiding();
            }
            ArrayList passengers = new ArrayList(current.getPassengers());
            for (Entity passenger : passengers) {
                if (processed.contains(passenger)) continue;
                queue.offer(passenger);
            }
        }
    }

    public static void dismountByRelationship(RidingRelationship relationship, Function<UUID, Entity> entityProvider) {
        if (relationship == null || entityProvider == null) {
            return;
        }
        ArrayDeque<RidingRelationship> stack = new ArrayDeque<RidingRelationship>();
        stack.push(relationship);
        while (!stack.isEmpty()) {
            RidingRelationship current = (RidingRelationship)stack.pop();
            Entity entity = entityProvider.apply(current.getEntityId());
            if (entity != null && entity.isPassenger()) {
                entity.stopRiding();
            }
            List<RidingRelationship> passengers = current.getPassengers();
            for (int i = passengers.size() - 1; i >= 0; --i) {
                stack.push(passengers.get(i));
            }
        }
    }

    public static void forceDismountAll(Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.isPassenger()) {
            entity.stopRiding();
        }
        List<Entity> allPassengers = RidingFinder.getAllPassengers(entity, false);
        for (Entity passenger : allPassengers) {
            if (!passenger.isPassenger()) continue;
            passenger.stopRiding();
        }
        if (!entity.getPassengers().isEmpty()) {
            entity.ejectPassengers();
        }
    }
}

