/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.riding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class RidingRelationship {
    private UUID entityId;
    private UUID vehicleId;
    private List<RidingRelationship> passengers;

    public RidingRelationship() {
        this.passengers = new ArrayList<RidingRelationship>();
    }

    public RidingRelationship(List<RidingRelationship> passengers, UUID vehicleId, UUID entityId) {
        this.passengers = passengers != null ? passengers : new ArrayList();
        this.vehicleId = vehicleId;
        this.entityId = entityId;
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public List<RidingRelationship> getPassengers() {
        return Collections.unmodifiableList(this.passengers);
    }

    public void setPassengers(List<RidingRelationship> passengers) {
        this.passengers = passengers != null ? passengers : new ArrayList();
    }

    public void addPassenger(RidingRelationship passenger) {
        this.passengers.add(passenger);
    }

    public UUID getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(UUID vehicleId) {
        this.vehicleId = vehicleId;
    }

    public int getTotalPassengerCount() {
        int count = this.passengers.size();
        for (RidingRelationship passenger : this.passengers) {
            count += passenger.getTotalPassengerCount();
        }
        return count;
    }

    public boolean containsEntity(UUID entityId) {
        if (Objects.equals(this.entityId, entityId)) {
            return true;
        }
        for (RidingRelationship passenger : this.passengers) {
            if (!passenger.containsEntity(entityId)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "RidingRelationship{entityId=" + this.entityId + ", vehicleId=" + this.vehicleId + ", passengers=" + this.passengers.size() + "}";
    }
}

