/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.riding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.r3944realms.lib39.util.lang.Pair;
import top.r3944realms.lib39.util.riding.RidingCycleException;
import top.r3944realms.lib39.util.riding.RidingFinder;
import top.r3944realms.lib39.util.riding.RidingRelationship;

public class RidingSaver {
    private static Function<UUID, Entity> entityProvider;

    @Contract(value="null -> new")
    @NotNull
    public static RidingRelationship save(@Nullable Entity entity) {
        return RidingSaver.save(entity, true);
    }

    @Contract(value="null, _ -> new")
    @NotNull
    public static RidingRelationship save(@Nullable Entity entity, boolean findRoot) {
        Entity rootEntity;
        if (entity == null) {
            return new RidingRelationship(Collections.emptyList(), null, null);
        }
        Entity entity2 = rootEntity = findRoot ? RidingFinder.findRootVehicle(entity) : entity;
        if (rootEntity == null) {
            return new RidingRelationship(Collections.emptyList(), null, null);
        }
        RidingRelationship rootRelationship = new RidingRelationship();
        rootRelationship.setEntityId(rootEntity.getUUID());
        rootRelationship.setVehicleId(null);
        rootRelationship.setPassengers(new ArrayList<RidingRelationship>());
        LinkedList<Pair<Entity, RidingRelationship>> queue = new LinkedList<Pair<Entity, RidingRelationship>>();
        queue.offer(Pair.of(rootEntity, rootRelationship));
        HashSet<UUID> processedEntities = new HashSet<UUID>();
        processedEntities.add(rootEntity.getUUID());
        while (!queue.isEmpty()) {
            Pair current = (Pair)queue.poll();
            Entity currentEntity = (Entity)current.first;
            RidingRelationship currentRelation = (RidingRelationship)current.second;
            List passengers = currentEntity.getPassengers();
            if (passengers.isEmpty()) continue;
            for (Entity passenger : passengers) {
                UUID passengerId = passenger.getUUID();
                if (!processedEntities.contains(passengerId)) {
                    processedEntities.add(passengerId);
                    RidingRelationship passengerRelation = new RidingRelationship();
                    passengerRelation.setEntityId(passengerId);
                    passengerRelation.setVehicleId(currentEntity.getUUID());
                    passengerRelation.setPassengers(new ArrayList<RidingRelationship>());
                    currentRelation.addPassenger(passengerRelation);
                    queue.offer(Pair.of(passenger, passengerRelation));
                    continue;
                }
                throw new RidingCycleException(passengerId, currentEntity.getUUID());
            }
        }
        return rootRelationship;
    }

    public static void setEntityProvider(Function<UUID, Entity> provider) {
        entityProvider = provider;
    }

    @Nullable
    private static EntityType<?> getEntityType(UUID entityId) {
        if (entityProvider == null) {
            return null;
        }
        Entity entity = entityProvider.apply(entityId);
        if (entity == null) {
            return null;
        }
        return entity.getType();
    }
}

