/*
 * Decompiled with CFR 0.152.
 */
package top.r3944realms.lib39.util.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ShapeUtil {
    @NotNull
    public static VoxelShape createPixelBasedShape(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Shapes.box((double)(minX / 16.0), (double)(minY / 16.0), (double)(minZ / 16.0), (double)(maxX / 16.0), (double)(maxY / 16.0), (double)(maxZ / 16.0));
    }

    @NotNull
    public static VoxelShape createBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @NotNull
    public static Map<Direction, VoxelShape> createUniformDirectionMap(VoxelShape shape) {
        return ShapeUtil.createRotatedDirectionMap(shape);
    }

    @NotNull
    public static Map<DoubleBlockHalf, Map<Direction, VoxelShape>> createDoubleBlockShapeMap(VoxelShape lowerShape, VoxelShape upperShape) {
        EnumMap<DoubleBlockHalf, Map<Direction, VoxelShape>> shapeMap = new EnumMap<DoubleBlockHalf, Map<Direction, VoxelShape>>(DoubleBlockHalf.class);
        shapeMap.put(DoubleBlockHalf.LOWER, ShapeUtil.createRotatedDirectionMap(lowerShape));
        shapeMap.put(DoubleBlockHalf.UPPER, ShapeUtil.createRotatedDirectionMap(upperShape));
        return shapeMap;
    }

    @NotNull
    public static VoxelShape rotateVoxelShapeClockwise(@NotNull VoxelShape shape) {
        ArrayList<VoxelShape> generatedShapes = new ArrayList<VoxelShape>();
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape rotated = Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
            generatedShapes.add(rotated);
        });
        return ShapeUtil.combineShapes(generatedShapes);
    }

    @NotNull
    public static VoxelShape rotateVoxelShapeXAxis(@NotNull VoxelShape shape) {
        ArrayList<VoxelShape> generatedShapes = new ArrayList<VoxelShape>();
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape rotated = Shapes.box((double)minX, (double)(1.0 - maxZ), (double)minY, (double)maxX, (double)(1.0 - minZ), (double)maxY);
            generatedShapes.add(rotated);
        });
        return ShapeUtil.combineShapes(generatedShapes);
    }

    @NotNull
    public static VoxelShape rotateVoxelShapeZAxis(@NotNull VoxelShape shape) {
        ArrayList<VoxelShape> generatedShapes = new ArrayList<VoxelShape>();
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape rotated = Shapes.box((double)minY, (double)minX, (double)minZ, (double)maxY, (double)maxX, (double)maxZ);
            generatedShapes.add(rotated);
        });
        return ShapeUtil.combineShapes(generatedShapes);
    }

    @NotNull
    public static VoxelShape rotateShape(@NotNull VoxelShape shape, int degrees) {
        int rotations = degrees / 90 % 4;
        VoxelShape result = shape;
        for (int i = 0; i < rotations; ++i) {
            result = ShapeUtil.rotateVoxelShapeClockwise(result);
        }
        return result;
    }

    @NotNull
    private static VoxelShape combineShapes(@NotNull List<VoxelShape> shapes) {
        if (shapes.isEmpty()) {
            return Shapes.block();
        }
        VoxelShape result = shapes.get(0);
        for (int i = 1; i < shapes.size(); ++i) {
            result = Shapes.or((VoxelShape)result, (VoxelShape)shapes.get(i));
        }
        return result.optimize();
    }

    @NotNull
    public static VoxelShape combineShapes(VoxelShape ... shapes) {
        return ShapeUtil.combineShapes(Arrays.asList(shapes));
    }

    @NotNull
    private static Map<Direction, VoxelShape> createRotatedDirectionMap(VoxelShape baseShape) {
        EnumMap<Direction, VoxelShape> directionMap = new EnumMap<Direction, VoxelShape>(Direction.class);
        directionMap.put(Direction.NORTH, baseShape);
        directionMap.put(Direction.EAST, ShapeUtil.rotateShape(baseShape, 90));
        directionMap.put(Direction.SOUTH, ShapeUtil.rotateShape(baseShape, 180));
        directionMap.put(Direction.WEST, ShapeUtil.rotateShape(baseShape, 270));
        return directionMap;
    }

    @Contract(value=" -> new")
    @NotNull
    public static ShapeBuilder builder() {
        return new ShapeBuilder();
    }

    public static class ShapeBuilder {
        private final List<VoxelShape> shapes = new ArrayList<VoxelShape>();

        public ShapeBuilder addPixelBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.shapes.add(ShapeUtil.createPixelBasedShape(minX, minY, minZ, maxX, maxY, maxZ));
            return this;
        }

        public ShapeBuilder addBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.shapes.add(ShapeUtil.createBox(minX, minY, minZ, maxX, maxY, maxZ));
            return this;
        }

        public ShapeBuilder addShape(VoxelShape shape) {
            this.shapes.add(shape);
            return this;
        }

        public VoxelShape build() {
            return ShapeUtil.combineShapes(this.shapes);
        }
    }
}

