/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.panel;

import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.GeneralStatWidget;
import io.github.thecsdev.betterstats.api.registry.BSRegistries;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.StatType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public final class StatsSummaryPanel
extends BSComponentPanel {
    public static final int ENTRY_HEIGHT = GeneralStatWidget.HEIGHT;
    private final List<Component[]> entries = new ArrayList<Component[]>();
    protected int columnCount = 2;

    public StatsSummaryPanel(int x, int y, int width) {
        this(x, y, width, 10 + ENTRY_HEIGHT * 3);
    }

    public StatsSummaryPanel(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.scrollFlags = 4;
        this.scrollPadding = 5;
    }

    public final void setColumnCount(int columnCount) {
        this.columnCount = Mth.clamp((int)columnCount, (int)1, (int)5);
        if (this.getParentTScreen() != null) {
            this.refresh();
        }
    }

    public final void clearEntries() {
        this.entries.clear();
    }

    public final void addEntry(@Nullable Component left, @Nullable Component right) {
        this.addEntry(left, null, right);
    }

    public final void addEntry(@Nullable Component left, @Nullable Component center, @Nullable Component right) {
        this.entries.add(new Component[]{left, center, right});
    }

    public final void summarizeItemStats(Iterable<SUItemStat> itemStats) {
        this.clearEntries();
        LinkedHashMap<StatType, Long> map = new LinkedHashMap<StatType, Long>();
        for (StatType statType2 : BuiltInRegistries.STAT_TYPE) {
            boolean isItem;
            Registry stR = statType2.getRegistry();
            boolean isBlock = stR == BuiltInRegistries.BLOCK;
            boolean bl = isItem = stR == BuiltInRegistries.ITEM;
            if (!isBlock && !isItem) continue;
            StatType statTypeO = statType2;
            long count = 0L;
            for (SUItemStat itemStat : itemStats) {
                count += (long)itemStat.getStatsProvider().getStatValue(statTypeO, isItem ? itemStat.getItem() : itemStat.getBlock());
            }
            map.put(statType2, count);
        }
        map.forEach((statType, statValue) -> this.addEntry(statType.getDisplayName(), (Component)TextUtils.literal((String)Long.toString(statValue))));
        if (this.getParentTScreen() != null) {
            this.refresh();
        }
    }

    public final void summarizeMobStats(Iterable<SUMobStat> mobStats) {
        this.clearEntries();
        LinkedHashMap<StatType, Long> map = new LinkedHashMap<StatType, Long>();
        for (StatType statType2 : BuiltInRegistries.STAT_TYPE) {
            if (statType2.getRegistry() != BuiltInRegistries.ENTITY_TYPE) continue;
            StatType statTypeE = statType2;
            long count = 0L;
            for (SUMobStat mobStat : mobStats) {
                count += (long)mobStat.getStatsProvider().getStatValue(statTypeE, mobStat.getEntityType());
            }
            map.put(statTypeE, count);
        }
        map.forEach((statType, statValue) -> {
            Component phrase = BSRegistries.getEntityStatTypePhrase(statType);
            this.addEntry(phrase, (Component)TextUtils.literal((String)Long.toString(statValue)));
        });
        if (this.getParentTScreen() != null) {
            this.refresh();
        }
    }

    protected final void init() {
        int sp = this.getScrollPadding();
        int entryWidth = (this.getWidth() - sp * 2) / Math.max(this.columnCount, 1);
        int row = 0;
        int column = 0;
        for (Component[] entry : this.entries) {
            int eX = sp + column * entryWidth;
            int eY = sp + row * ENTRY_HEIGHT;
            int ha = 0;
            for (Component entryText : entry) {
                ++ha;
                if (entryText == null) continue;
                TLabelElement lbl = new TLabelElement(eX, eY, entryWidth, ENTRY_HEIGHT, entryText);
                lbl.setTextSideOffset(5);
                switch (ha) {
                    case 1: {
                        lbl.setTextHorizontalAlignment(HorizontalAlignment.LEFT);
                        break;
                    }
                    case 2: {
                        lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
                        break;
                    }
                    case 3: {
                        lbl.setTextHorizontalAlignment(HorizontalAlignment.RIGHT);
                        break;
                    }
                }
                this.addChild((TElement)lbl, true);
            }
            if (++column < this.columnCount) continue;
            column = 0;
            ++row;
        }
    }

    public final void autoHeight() {
        int rows = (int)Math.ceil((double)this.entries.size() / (double)Math.max(this.columnCount, 1));
        int height = rows * ENTRY_HEIGHT + this.getScrollPadding() * 2;
        this.setSize(this.getWidth(), height);
    }
}

