/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.widget;

import io.github.thecsdev.betterstats.api.client.gui.stats.widget.AbstractStatWidget;
import io.github.thecsdev.betterstats.api.registry.BSRegistries;
import io.github.thecsdev.betterstats.api.util.enumerations.ItemStatType;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;

@Virtual
public class ItemStatWidget
extends AbstractStatWidget<SUItemStat> {
    public static final int SIZE = 21;
    public static final Component TEXT_STAT_MINED = ItemStatType.MINED.getText();
    public static final Component TEXT_STAT_CRAFTED = ItemStatType.CRAFTED.getText();
    public static final Component TEXT_STAT_PICKED_UP = ItemStatType.PICKED_UP.getText();
    public static final Component TEXT_STAT_DROPPED = ItemStatType.DROPPED.getText();
    public static final Component TEXT_STAT_USED = ItemStatType.USED.getText();
    public static final Component TEXT_STAT_BROKEN = ItemStatType.BROKEN.getText();
    protected final ItemStack itemStack;
    protected final Tooltip defaultTooltip;

    public ItemStatWidget(int x, int y, SUItemStat stat) throws NullPointerException {
        this(x, y, 21, stat);
    }

    public ItemStatWidget(int x, int y, int size, SUItemStat stat) throws NullPointerException {
        super(x, y, size, size, stat);
        this.itemStack = stat.getItem().getDefaultInstance();
        StringBuilder tttb = new StringBuilder();
        boolean hasNoBlock = stat.getBlock() == null || stat.getBlock() == Blocks.AIR;
        BuiltInRegistries.STAT_TYPE.forEach(st -> {
            boolean stRegIsItem;
            boolean bl = stRegIsItem = st.getRegistry() == BuiltInRegistries.ITEM;
            if (!stRegIsItem && (hasNoBlock || st.getRegistry() != BuiltInRegistries.BLOCK)) {
                return;
            }
            Stat stStat = st.get(stRegIsItem ? stat.getItem() : stat.getBlock());
            String val = stStat.format(stat.getStatsProvider().getStatValue(stStat));
            tttb.append("\u00a7e-\u00a7r ");
            tttb.append(Optional.ofNullable(st.getDisplayName()).orElse((Component)TextUtils.literal((String)"???")).getString());
            tttb.append(": " + val + "\n");
        });
        MutableComponent ttt = TextUtils.literal((String)"").append((Component)TextUtils.literal((String)"").append(stat.getStatLabel()).withStyle(ChatFormatting.YELLOW)).append("\n").append((Component)TextUtils.literal((String)Objects.toString(stat.getStatID())).withStyle(ChatFormatting.GRAY)).append("\n\n\u00a7r").append(tttb.toString().trim());
        this.defaultTooltip = Tooltip.create((Component)ttt);
        this.setTooltip(this.defaultTooltip);
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        String url;
        if (inputContext.getInputType() != TInputContext.InputType.MOUSE_PRESS) {
            return false;
        }
        int btn = inputContext.getMouseButton();
        if (!(btn != 0 && btn != 1 || this.itemStack == null || TScreen.hasShiftDown())) {
            try {
                ViewSearchBuilder builder = ViewSearchBuilder.builder();
                EntryStack entryStack = EntryStacks.of((ItemStack)this.itemStack);
                if (btn == 0) {
                    builder.addRecipesFor(entryStack);
                } else if (btn == 1) {
                    builder.addUsagesFor(entryStack);
                }
                boolean opened = ClientHelper.getInstance().openView(builder);
                if (opened) {
                    return false;
                }
            }
            catch (NoClassDefFoundError builder) {}
        } else if (btn == 2 && (url = BSRegistries.getItemWikiURL(((SUItemStat)this.stat).getStatID())) != null) {
            GuiUtils.showUrlPrompt((String)url, (boolean)false);
            return false;
        }
        return super.input(inputContext);
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        super.render(pencil);
        pencil.renderItem(this.itemStack, this.getX() + 3, this.getY() + 3);
    }
}

