/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.widget;

import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.AbstractStatWidget;
import io.github.thecsdev.betterstats.api.registry.BSRegistries;
import io.github.thecsdev.betterstats.api.util.enumerations.MobStatType;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TEntityRendererElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.EntityType;

@Deprecated(since="3.13.9")
@Virtual
public class MobStatWidget
extends AbstractStatWidget<SUMobStat> {
    private static final BetterStatsConfig BSS_CONFIG = BetterStats.getInstance().getConfig();
    public static final int SIZE = 55;
    public static final Component TEXT_STAT_KILLS = MobStatType.KILLED.getText();
    public static final Component TEXT_STAT_DEATHS = MobStatType.KILLED_BY.getText();
    protected final EntityType<?> entityType;
    protected final TEntityRendererElement entityRenderer;
    protected final Tooltip defaultTooltip;

    public MobStatWidget(int x, int y, SUMobStat stat) throws NullPointerException {
        this(x, y, 55, stat);
    }

    public MobStatWidget(int x, int y, int size, SUMobStat stat) throws NullPointerException {
        super(x, y, size, size, stat);
        this.entityType = stat.getEntityType();
        this.defaultTooltip = Tooltip.create((Component)MobStatWidget.createTooltipText(stat));
        this.setTooltip(this.defaultTooltip);
        this.entityRenderer = new TEntityRendererElement(x, y, size, size, this.entityType);
        this.entityRenderer.setFollowsCursor(MobStatWidget.BSS_CONFIG.guiMobsFollowCursor);
        this.addChild((TElement)this.entityRenderer, false);
    }

    @Virtual
    public void setSize(int width, int height, int flags) {
        super.setSize(width, height, flags);
        this.entityRenderer.setSize(width, height, flags);
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        String url;
        if (inputContext.getInputType() != TInputContext.InputType.MOUSE_PRESS) {
            return false;
        }
        int btn = inputContext.getMouseButton();
        if (btn == 2 && (url = BSRegistries.getMobWikiURL(((SUMobStat)this.stat).getStatID())) != null) {
            GuiUtils.showUrlPrompt((String)url, (boolean)false);
            return false;
        }
        return super.input(inputContext);
    }

    public static final Component createTooltipText(SUMobStat stat) throws NullPointerException {
        MutableComponent ttt = TextUtils.literal((String)"").append((Component)TextUtils.literal((String)"").append(stat.getStatLabel()).withStyle(ChatFormatting.YELLOW)).append("\n\u00a77" + String.valueOf(stat.getStatID())).append("\n\u00a7r");
        for (StatType statType : BuiltInRegistries.STAT_TYPE) {
            if (statType.getRegistry() != BuiltInRegistries.ENTITY_TYPE) continue;
            Function<SUMobStat, Component> textFormatter = BSRegistries.ENTITY_STAT_TEXT_FORMATTER.get(statType);
            if (textFormatter != null) {
                ttt.append("\n\u00a7e-\u00a7r ").append(textFormatter.apply(stat));
                continue;
            }
            StatType statTypeE = statType;
            int stVal = stat.getStatsProvider().getStatValue(statTypeE, stat.getEntityType());
            ttt.append("\n\u00a7e-\u00a7r ").append(BSRegistries.getEntityStatTypePhrase(statTypeE)).append(": " + statTypeE.get(stat.getEntityType()).format(stVal));
        }
        return ttt;
    }
}

