/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.enumerations;

import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProvider;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;

public enum ItemStatType implements ITextProvider
{
    MINED(Stats.BLOCK_MINED, (Component)TextUtils.translatable((String)"stat_type.minecraft.mined", (Object[])new Object[0]), s -> s.mined),
    CRAFTED(Stats.ITEM_CRAFTED, (Component)TextUtils.translatable((String)"stat_type.minecraft.crafted", (Object[])new Object[0]), s -> s.crafted),
    PICKED_UP(Stats.ITEM_PICKED_UP, (Component)TextUtils.translatable((String)"stat_type.minecraft.picked_up", (Object[])new Object[0]), s -> s.pickedUp),
    DROPPED(Stats.ITEM_DROPPED, (Component)TextUtils.translatable((String)"stat_type.minecraft.dropped", (Object[])new Object[0]), s -> s.dropped),
    USED(Stats.ITEM_USED, (Component)TextUtils.translatable((String)"stat_type.minecraft.used", (Object[])new Object[0]), s -> s.used),
    BROKEN(Stats.ITEM_BROKEN, (Component)TextUtils.translatable((String)"stat_type.minecraft.broken", (Object[])new Object[0]), s -> s.broken);

    private final StatType<?> statType;
    private final Component text;
    private final Function<SUItemStat, Integer> statValueSupplier;

    private ItemStatType(StatType<?> statType, Component text, Function<SUItemStat, Integer> statValueSupplier) {
        this.statType = Objects.requireNonNull(statType);
        this.text = Objects.requireNonNull(text);
        this.statValueSupplier = Objects.requireNonNull(statValueSupplier);
    }

    public final StatType<?> getStatType() {
        return this.statType;
    }

    public final Component getText() {
        return this.text;
    }

    public final int getStatValue(SUItemStat stat) throws NullPointerException {
        return this.statValueSupplier.apply(Objects.requireNonNull(stat));
    }

    public static final boolean isItemStat(Stat<?> stat) {
        StatType statType = stat.getType();
        for (ItemStatType val : ItemStatType.values()) {
            if (!Objects.equals(statType, val.statType)) continue;
            return true;
        }
        return false;
    }
}

