/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.enumerations;

import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProvider;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;

public enum MobStatType implements ITextProvider
{
    KILLED(Stats.ENTITY_KILLED, (Component)BST.stp_mc_killed(), s -> s.kills),
    KILLED_BY(Stats.ENTITY_KILLED_BY, (Component)BST.stp_mc_killedBy(), s -> s.deaths);

    private final StatType<?> statType;
    private final Component text;
    private final Function<SUMobStat, Integer> statValueSupplier;

    private MobStatType(StatType<?> statType, Component text, Function<SUMobStat, Integer> statValueSupplier) {
        this.statType = Objects.requireNonNull(statType);
        this.text = Objects.requireNonNull(text);
        this.statValueSupplier = Objects.requireNonNull(statValueSupplier);
    }

    public final StatType<?> getStatType() {
        return this.statType;
    }

    public final Component getText() {
        return this.text;
    }

    public final int getStatValue(SUMobStat stat) throws NullPointerException {
        return this.statValueSupplier.apply(Objects.requireNonNull(stat));
    }

    public static final boolean isMobStat(Stat<?> stat) {
        StatType statType = stat.getType();
        for (MobStatType val : MobStatType.values()) {
            if (!Objects.equals(statType, val.statType)) continue;
            return true;
        }
        return false;
    }
}

