/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IllegalHeaderException;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.exceptions.UnsupportedFileVersionException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import org.jetbrains.annotations.Nullable;

public class RAMStatsProvider
implements IEditableStatsProvider {
    @Nullable
    protected Component displayName;
    @Nullable
    protected GameProfile gameProfile;
    protected final Object2IntMap<Stat<?>> statMap = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());
    protected final Object2IntMap<ResourceLocation> playerBadgeStatMap = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public RAMStatsProvider() {
        this.statMap.defaultReturnValue(0);
        this.playerBadgeStatMap.defaultReturnValue(0);
    }

    public RAMStatsProvider(FriendlyByteBuf buffer, boolean releaseBuffer) throws NullPointerException, IllegalHeaderException, UnsupportedFileVersionException {
        this();
        try {
            StatsProviderIO.read(Objects.requireNonNull(buffer), this);
        }
        finally {
            if (releaseBuffer && buffer.refCnt() > 0) {
                buffer.release();
            }
        }
    }

    @Override
    public final Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public final void setDisplayName(Component displayName) {
        if (displayName == null) {
            displayName = TextUtils.literal((String)"-");
        }
        this.displayName = displayName;
    }

    @Override
    public final GameProfile getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public final void setGameProfile(@Nullable GameProfile playerProfile) {
        this.gameProfile = playerProfile;
    }

    @Override
    public final int getStatValue(Stat<?> stat) {
        return this.statMap.getInt(stat);
    }

    @Override
    public final void setStatValue(Stat<?> stat, int value) throws NullPointerException {
        if (value < 1) {
            this.statMap.removeInt(stat);
        } else {
            this.statMap.put(Objects.requireNonNull(stat), value);
        }
    }

    @Override
    public final int getPlayerBadgeValue(ResourceLocation badgeId) {
        return this.playerBadgeStatMap.getInt((Object)badgeId);
    }

    @Override
    public final void setPlayerBadgeValue(ResourceLocation badgeId, int value) throws NullPointerException {
        if (value < 1) {
            this.playerBadgeStatMap.removeInt((Object)badgeId);
        } else {
            this.playerBadgeStatMap.put((Object)Objects.requireNonNull(badgeId), value);
        }
    }

    public final Object2IntMap<Stat<?>> getStatMap() {
        return this.statMap;
    }

    public final Object2IntMap<ResourceLocation> getPlayerBadgeStatMap() {
        return this.playerBadgeStatMap;
    }
}

